/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.any23.extractor.ExtractorFactory;
import org.apache.any23.mime.MIMEType;

public class ExtractorGroup
implements Iterable<ExtractorFactory<?>> {
    private final Collection<ExtractorFactory<?>> factories;

    public ExtractorGroup(Collection<ExtractorFactory<?>> factories) {
        this.factories = factories;
    }

    public boolean isEmpty() {
        return this.factories.isEmpty();
    }

    public int getNumOfExtractors() {
        return this.factories.size();
    }

    public ExtractorGroup filterByMIMEType(MIMEType mimeType) {
        ArrayList matching = new ArrayList();
        for (ExtractorFactory<?> factory : this.factories) {
            if (!this.supportsAllContentTypes(factory) && !this.supports(factory, mimeType)) continue;
            matching.add(factory);
        }
        return new ExtractorGroup(matching);
    }

    @Override
    public Iterator<ExtractorFactory<?>> iterator() {
        return this.factories.iterator();
    }

    public boolean allExtractorsSupportAllContentTypes() {
        for (ExtractorFactory<?> factory : this.factories) {
            if (this.supportsAllContentTypes(factory)) continue;
            return false;
        }
        return true;
    }

    private boolean supportsAllContentTypes(ExtractorFactory<?> factory) {
        return factory.getSupportedMIMETypes().contains("*/*");
    }

    private boolean supports(ExtractorFactory<?> factory, MIMEType mimeType) {
        for (MIMEType supported : factory.getSupportedMIMETypes()) {
            if (supported.isAnyMajorType()) {
                return true;
            }
            if (supported.isAnySubtype() && supported.getMajorType().equals(mimeType.getMajorType())) {
                return true;
            }
            if (!supported.getFullType().equals(mimeType.getFullType())) continue;
            return true;
        }
        return false;
    }
}

