/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.vocab;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public abstract class Vocabulary {
    private final IRI namespace;
    private Map<String, IRI> classes;
    private Map<String, IRI> properties;
    private Map<IRI, String> resourceToCommentMap;

    public Vocabulary(String namespace) {
        try {
            this.namespace = SimpleValueFactory.getInstance().createIRI(namespace);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid namespace '" + namespace + "'", e);
        }
    }

    public IRI getNamespace() {
        return this.namespace;
    }

    public IRI getClass(String name) {
        IRI res = this.classes.get(name);
        if (null == res) {
            throw new IllegalArgumentException("Unknown resource name '" + name + "'");
        }
        return res;
    }

    public IRI getProperty(String name) {
        IRI prop = this.properties.get(name);
        if (null == prop) {
            throw new IllegalArgumentException("Unknown property name '" + name + "'");
        }
        return prop;
    }

    public IRI getProperty(String name, IRI defaultValue) {
        IRI prop = this.properties.get(name);
        if (null == prop) {
            return defaultValue;
        }
        return prop;
    }

    public IRI getPropertyCamelCase(String property) {
        String[] names = property.split("\\W");
        Object camelCase = names[0];
        for (int i = 1; i < names.length; ++i) {
            String tmp = names[i];
            camelCase = (String)camelCase + tmp.replaceFirst("(.)", tmp.substring(0, 1).toUpperCase(Locale.ROOT));
        }
        return this.getProperty((String)camelCase);
    }

    public IRI[] getClasses() {
        if (this.classes == null) {
            return new IRI[0];
        }
        Collection<IRI> iris = this.classes.values();
        return iris.toArray(new IRI[iris.size()]);
    }

    public IRI[] getProperties() {
        if (this.properties == null) {
            return new IRI[0];
        }
        Collection<IRI> iris = this.properties.values();
        return iris.toArray(new IRI[iris.size()]);
    }

    public Map<IRI, String> getComments() {
        this.fillResourceToCommentMap();
        return Collections.unmodifiableMap(this.resourceToCommentMap);
    }

    public String getCommentFor(IRI resource) {
        this.fillResourceToCommentMap();
        return this.resourceToCommentMap.get(resource);
    }

    protected static IRI createIRI(String iriStr) {
        return SimpleValueFactory.getInstance().createIRI(iriStr);
    }

    protected IRI createClass(String namespace, String resource) {
        IRI res = Vocabulary.createIRI(namespace, resource);
        if (this.classes == null) {
            this.classes = new HashMap<String, IRI>(10);
        }
        this.classes.put(resource, res);
        return res;
    }

    protected IRI createProperty(String namespace, String property) {
        IRI res = Vocabulary.createIRI(namespace, property);
        if (this.properties == null) {
            this.properties = new HashMap<String, IRI>(10);
        }
        this.properties.put(property, res);
        return res;
    }

    private static IRI createIRI(String namespace, String localName) {
        return SimpleValueFactory.getInstance().createIRI(namespace, localName);
    }

    private void fillResourceToCommentMap() {
        if (this.resourceToCommentMap != null) {
            return;
        }
        HashMap<IRI, String> newMap = new HashMap<IRI, String>();
        for (Field field : this.getClass().getFields()) {
            try {
                Comment comment;
                Object value = field.get(this);
                if (!(value instanceof IRI) || (comment = field.getAnnotation(Comment.class)) == null) continue;
                newMap.put((IRI)value, comment.value());
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Error while creating resource to comment map.", iae);
            }
        }
        this.resourceToCommentMap = newMap;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Comment {
        public String value();
    }
}

