/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.mime.purifier;

import java.io.IOException;
import java.io.InputStream;
import org.apache.any23.mime.purifier.Purifier;

public class WhiteSpacesPurifier
implements Purifier {
    public void purify(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("Provided InputStream does not support marks");
        }
        inputStream.mark(Integer.MAX_VALUE);
        int byteRead = inputStream.read();
        char charRead = (char)byteRead;
        while (this.isBlank(charRead) && byteRead != -1) {
            inputStream.mark(Integer.MAX_VALUE);
            byteRead = inputStream.read();
            charRead = (char)byteRead;
        }
        inputStream.reset();
    }

    private boolean isBlank(char c) {
        return c == '\t' || c == '\n' || c == ' ' || c == '\r' || c == '\b' || c == '\f';
    }
}

