/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.any23.configuration.Configuration;
import org.apache.any23.configuration.DefaultConfiguration;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.http.HTTPClient;
import org.apache.any23.servlet.WebResponder;
import org.apache.any23.servlet.conneg.Any23Negotiator;
import org.apache.any23.servlet.conneg.MediaRangeSpec;
import org.apache.any23.source.ByteArrayDocumentSource;
import org.apache.any23.source.DocumentSource;
import org.apache.any23.source.HTTPDocumentSource;
import org.apache.any23.source.StringDocumentSource;

public class Servlet
extends HttpServlet {
    public static final String DEFAULT_BASE_URI = "http://any23.org/tmp/";
    private static final long serialVersionUID = 8207685628715421336L;
    private static final Pattern schemeRegex = Pattern.compile("^[a-zA-Z][a-zA-Z0-9.+-]*:");
    private static final Pattern schemeAndSingleSlashRegex = Pattern.compile("^[a-zA-Z][a-zA-Z0-9.+-]*:/[^/]");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        WebResponder responder = new WebResponder(this, resp);
        String format = this.getFormatFromRequestOrNegotiation(req);
        boolean report = this.isReport(req);
        boolean annotate = this.isAnnotated(req);
        if (format == null) {
            responder.sendError(406, "Client accept header does not include a supported output format", report);
            return;
        }
        String uri = this.getInputURIFromRequest(req);
        if (uri == null) {
            responder.sendError(404, "Missing URI in GET request. Try /format/http://example.com/myfile", report);
            return;
        }
        ExtractionParameters eps = this.getExtractionParameters(req);
        responder.runExtraction(this.createHTTPDocumentSource(responder, uri, report), eps, format, report, annotate);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        WebResponder responder = new WebResponder(this, resp);
        boolean report = this.isReport(req);
        boolean annotate = this.isAnnotated(req);
        if (req.getContentType() == null) {
            responder.sendError(400, "Invalid POST request, no Content-Type for the message body specified", report);
            return;
        }
        String uri = this.getInputURIFromRequest(req);
        String format = this.getFormatFromRequestOrNegotiation(req);
        if (format == null) {
            responder.sendError(406, "Client accept header does not include a supported output format", report);
            return;
        }
        ExtractionParameters eps = this.getExtractionParameters(req);
        if ("application/x-www-form-urlencoded".equals(this.getContentTypeHeader(req))) {
            if (uri != null) {
                this.log("Attempting conversion to '" + format + "' from URI <" + uri + ">");
                responder.runExtraction(this.createHTTPDocumentSource(responder, uri, report), eps, format, report, annotate);
                return;
            }
            if (req.getParameter("body") == null) {
                responder.sendError(400, "Invalid POST request, parameter 'uri' or 'body' required", report);
                return;
            }
            String type = null;
            if (req.getParameter("type") != null && !"".equals(req.getParameter("type"))) {
                type = req.getParameter("type");
            }
            this.log("Attempting conversion to '" + format + "' from body parameter");
            responder.runExtraction((DocumentSource)new StringDocumentSource(req.getParameter("body"), DEFAULT_BASE_URI, type), eps, format, report, annotate);
            return;
        }
        this.log("Attempting conversion to '" + format + "' from POST body");
        responder.runExtraction((DocumentSource)new ByteArrayDocumentSource((InputStream)req.getInputStream(), DEFAULT_BASE_URI, this.getContentTypeHeader(req)), eps, format, report, annotate);
    }

    private String getFormatFromRequestOrNegotiation(HttpServletRequest request) {
        String fromRequest = this.getFormatFromRequest(request);
        if (fromRequest != null && !"".equals(fromRequest) && !"best".equals(fromRequest)) {
            return fromRequest;
        }
        MediaRangeSpec result = Any23Negotiator.getNegotiator().getBestMatch(request.getHeader("Accept"));
        if (result == null) {
            return null;
        }
        if ("text/turtle".equals(result.getMediaType())) {
            return "turtle";
        }
        if ("text/rdf+n3".equals(result.getMediaType())) {
            return "n3";
        }
        if ("text/rdf+nq".equals(result.getMediaType())) {
            return "nq";
        }
        if ("application/rdf+xml".equals(result.getMediaType())) {
            return "rdf";
        }
        if ("text/plain".equals(result.getMediaType())) {
            return "nt";
        }
        return "turtle";
    }

    private String getFormatFromRequest(HttpServletRequest request) {
        if (request.getPathInfo() == null) {
            return "best";
        }
        String[] args = request.getPathInfo().split("/", 3);
        if (args.length < 2 || "".equals(args[1])) {
            if (request.getParameter("format") == null) {
                return "best";
            }
            return request.getParameter("format");
        }
        return args[1];
    }

    private String getInputURIFromRequest(HttpServletRequest request) {
        if (request.getPathInfo() == null) {
            return null;
        }
        String[] args = request.getPathInfo().split("/", 3);
        if (args.length < 3) {
            if (request.getParameter("uri") != null) {
                return request.getParameter("uri").trim();
            }
            if (request.getParameter("url") != null) {
                return request.getParameter("url").trim();
            }
            return null;
        }
        String uri = args[2];
        if (request.getQueryString() != null) {
            uri = uri + "?" + request.getQueryString();
        }
        if (!this.hasScheme(uri)) {
            uri = "http://" + uri;
        } else if (this.hasOnlySingleSlashAfterScheme(uri)) {
            uri = uri.replaceFirst(":/", "://");
        }
        return uri.trim();
    }

    private boolean hasScheme(String uri) {
        return schemeRegex.matcher(uri).find();
    }

    private boolean hasOnlySingleSlashAfterScheme(String uri) {
        return schemeAndSingleSlashRegex.matcher(uri).find();
    }

    private String getContentTypeHeader(HttpServletRequest req) {
        if (req.getHeader("Content-Type") == null) {
            return null;
        }
        if ("".equals(req.getHeader("Content-Type"))) {
            return null;
        }
        String contentType = req.getHeader("Content-Type");
        int index = contentType.indexOf(";");
        if (index == -1) {
            return contentType;
        }
        return contentType.substring(0, index);
    }

    private DocumentSource createHTTPDocumentSource(WebResponder responder, String uri, boolean report) throws IOException {
        try {
            if (!this.isValidURI(uri)) {
                throw new URISyntaxException(uri, "@@@");
            }
            return this.createHTTPDocumentSource(responder.getRunner().getHTTPClient(), uri);
        }
        catch (URISyntaxException ex) {
            responder.sendError(400, "Invalid input URI " + uri, report);
            return null;
        }
    }

    protected DocumentSource createHTTPDocumentSource(HTTPClient httpClient, String uri) throws IOException, URISyntaxException {
        return new HTTPDocumentSource(httpClient, uri);
    }

    private boolean isValidURI(String s) {
        try {
            URI uri = new URI(s);
            if (!"http".equals(uri.getScheme()) && !"https".equals(uri.getScheme())) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    private ExtractionParameters.ValidationMode getValidationMode(HttpServletRequest request) {
        String PARAMETER = "validation-mode";
        String validationMode = request.getParameter("validation-mode");
        if (validationMode == null) {
            return ExtractionParameters.ValidationMode.None;
        }
        if ("none".equalsIgnoreCase(validationMode)) {
            return ExtractionParameters.ValidationMode.None;
        }
        if ("validate".equalsIgnoreCase(validationMode)) {
            return ExtractionParameters.ValidationMode.Validate;
        }
        if ("validate-fix".equalsIgnoreCase(validationMode)) {
            return ExtractionParameters.ValidationMode.ValidateAndFix;
        }
        throw new IllegalArgumentException(String.format("Invalid value '%s' for '%s' parameter.", validationMode, "validation-mode"));
    }

    private ExtractionParameters getExtractionParameters(HttpServletRequest request) {
        ExtractionParameters.ValidationMode mode = this.getValidationMode(request);
        return new ExtractionParameters((Configuration)DefaultConfiguration.singleton(), mode);
    }

    private boolean isReport(HttpServletRequest request) {
        return request.getParameter("report") != null;
    }

    private boolean isAnnotated(HttpServletRequest request) {
        return request.getParameter("annotate") != null;
    }
}

