/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.any23.Any23;
import org.apache.any23.ExtractionReport;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.filter.IgnoreAccidentalRDFa;
import org.apache.any23.filter.IgnoreTitlesOfEmptyDocuments;
import org.apache.any23.servlet.Servlet;
import org.apache.any23.source.DocumentSource;
import org.apache.any23.validator.SerializationException;
import org.apache.any23.validator.XMLValidationReportSerializer;
import org.apache.any23.writer.CompositeTripleHandler;
import org.apache.any23.writer.CountingTripleHandler;
import org.apache.any23.writer.FormatWriter;
import org.apache.any23.writer.ReportingTripleHandler;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.WriterFactory;
import org.apache.any23.writer.WriterFactoryRegistry;
import sun.security.validator.ValidatorException;

class WebResponder {
    private static final WriterFactoryRegistry writerRegistry = WriterFactoryRegistry.getInstance();
    private final Any23 runner;
    private Servlet any23servlet;
    private HttpServletResponse response;
    private TripleHandler rdfWriter = null;
    private ReportingTripleHandler reporter = null;
    private String outputMediaType = null;
    private ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();

    public WebResponder(Servlet any23servlet, HttpServletResponse response) {
        this.any23servlet = any23servlet;
        this.response = response;
        this.runner = new Any23();
        this.runner.setHTTPUserAgent("Any23-Servlet");
    }

    protected Any23 getRunner() {
        return this.runner;
    }

    public void runExtraction(DocumentSource in, ExtractionParameters eps, String format, boolean report, boolean annotate) throws IOException {
        ExtractionReport er;
        if (in == null) {
            return;
        }
        if (!this.initRdfWriter(format, report, annotate)) {
            return;
        }
        try {
            er = this.runner.extract(eps, in, this.rdfWriter);
            this.rdfWriter.close();
            if (!er.hasMatchingExtractors()) {
                this.sendError(415, "No suitable extractor found for this media type", null, er, report);
                return;
            }
        }
        catch (IOException ioe) {
            if (ioe.getCause() != null && ValidatorException.class.equals(ioe.getCause().getClass())) {
                String errMsg = "Could not fetch input, IO Error.";
                this.any23servlet.log("Could not fetch input, IO Error.", ioe.getCause());
                this.sendError(502, "Could not fetch input, IO Error.", (Exception)ioe, null, report);
                return;
            }
            this.any23servlet.log("Could not fetch input", (Throwable)ioe);
            this.sendError(502, "Could not fetch input.", (Exception)ioe, null, report);
            return;
        }
        catch (ExtractionException e) {
            this.any23servlet.log("Could not parse input", (Throwable)e);
            this.sendError(502, "Could not parse input.", (Exception)((Object)e), null, report);
            return;
        }
        catch (Exception e) {
            this.any23servlet.log("Internal error", (Throwable)e);
            this.sendError(500, "Internal error.", e, null, report);
            return;
        }
        this.any23servlet.log("Extraction complete, " + this.reporter.getTotalTriples() + " triples");
        if (this.reporter.getTotalTriples() == 0) {
            this.sendError(501, "Extraction completed. No triples have been found.", null, er, report);
            return;
        }
        this.response.setContentType(this.outputMediaType);
        this.response.setStatus(200);
        String charsetEncoding = er.getEncoding();
        if (Charset.isSupported(charsetEncoding)) {
            this.response.setCharacterEncoding(er.getEncoding());
        } else {
            this.response.setCharacterEncoding("UTF-8");
        }
        ServletOutputStream sos = this.response.getOutputStream();
        byte[] data = this.byteOutStream.toByteArray();
        if (report) {
            PrintStream ps = new PrintStream((OutputStream)sos);
            try {
                this.printHeader(ps);
                this.printResponse(this.reporter, er, data, ps);
            }
            catch (Exception e) {
                throw new RuntimeException("An error occurred while serializing the output response.", e);
            }
            finally {
                ps.close();
            }
        } else {
            sos.write(data);
        }
    }

    public void sendError(int code, String msg, boolean report) throws IOException {
        this.sendError(code, msg, null, null, report);
    }

    private void printHeader(PrintStream ps) {
        ps.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
    }

    private void printResponse(ReportingTripleHandler rth, ExtractionReport er, byte[] data, PrintStream ps) {
        ps.println("<response>");
        this.printExtractors(rth, ps);
        this.printReport(null, null, er, ps);
        this.printData(data, ps);
        ps.println("</response>");
    }

    private void printExtractors(ReportingTripleHandler rth, PrintStream ps) {
        ps.println("<extractors>");
        for (String extractor : rth.getExtractorNames()) {
            ps.print("<extractor>");
            ps.print(extractor);
            ps.println("</extractor>");
        }
        ps.println("</extractors>");
    }

    private void printIssueReport(ExtractionReport er, PrintStream ps) {
        ps.println("<issueReport>");
        for (Extractor extractor : er.getMatchingExtractors()) {
            String name = extractor.getDescription().getExtractorName();
            Collection extractorIssues = er.getExtractorIssues(name);
            if (extractorIssues.isEmpty()) continue;
            ps.println(String.format("<extractorIssues extractor=\"%s\">", name));
            for (IssueReport.Issue issue : er.getExtractorIssues(name)) {
                ps.println(String.format("<issue level=\"%s\" row=\"%d\" col=\"%d\">%s</issue>", issue.getLevel().toString(), issue.getRow(), issue.getCol(), issue.getMessage()));
            }
            ps.println("</extractorIssues>");
        }
        ps.println("</issueReport>");
    }

    private void printReport(String msg, Throwable e, ExtractionReport er, PrintStream ps) {
        XMLValidationReportSerializer reportSerializer = new XMLValidationReportSerializer();
        ps.println("<report>");
        if (msg != null) {
            ps.printf("<message>%s</message>\n", msg);
        } else {
            ps.print("<message/>\n");
        }
        if (e != null) {
            ps.println("<error>");
            ps.println("<![CDATA[");
            e.printStackTrace(ps);
            ps.println("]]>");
            ps.println("</error>");
        } else {
            ps.println("<error/>");
        }
        this.printIssueReport(er, ps);
        try {
            reportSerializer.serialize(er.getValidationReport(), (OutputStream)ps);
        }
        catch (SerializationException se) {
            ps.println("An error occurred while serializing error.");
            se.printStackTrace(ps);
        }
        ps.println("</report>");
    }

    private void printData(byte[] data, PrintStream ps) {
        ps.println("<data>");
        ps.println("<![CDATA[");
        try {
            ps.write(data);
        }
        catch (IOException ioe) {
            ps.println("An error occurred while serializing data.");
            ioe.printStackTrace(ps);
        }
        ps.println("]]>");
        ps.println("</data>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError(int code, String msg, Exception e, ExtractionReport er, boolean report) throws IOException {
        this.response.setStatus(code);
        this.response.setContentType("text/plain");
        PrintStream ps = new PrintStream((OutputStream)this.response.getOutputStream());
        if (report) {
            try {
                this.printHeader(ps);
                this.printReport(msg, (Throwable)e, er, ps);
            }
            finally {
                ps.close();
            }
        } else {
            ps.println(msg);
            if (e != null) {
                ps.println("================================================================");
                e.printStackTrace(ps);
                ps.println("================================================================");
            }
        }
    }

    private boolean initRdfWriter(String format, boolean report, boolean annotate) throws IOException {
        WriterFactory factory = this.getFormatWriter(format);
        if (factory == null) {
            this.sendError(400, "Invalid format '" + format + "', try one of: [rdfxml, turtle, ntriples, nquads, trix, json]", null, null, report);
            return false;
        }
        FormatWriter fw = factory.getRdfWriter((OutputStream)this.byteOutStream);
        fw.setAnnotated(annotate);
        this.outputMediaType = factory.getMimeType();
        ArrayList<Object> tripleHandlers = new ArrayList<Object>();
        tripleHandlers.add(new IgnoreAccidentalRDFa((TripleHandler)fw));
        tripleHandlers.add(new CountingTripleHandler());
        this.rdfWriter = new CompositeTripleHandler(tripleHandlers);
        this.reporter = new ReportingTripleHandler(this.rdfWriter);
        this.rdfWriter = new IgnoreAccidentalRDFa((TripleHandler)new IgnoreTitlesOfEmptyDocuments((TripleHandler)this.reporter), true);
        return true;
    }

    private WriterFactory getFormatWriter(String format) throws IOException {
        String finalFormat;
        if ("rdf".equals(format) || "xml".equals(format) || "rdfxml".equals(format)) {
            finalFormat = "rdfxml";
        } else if ("turtle".equals(format) || "ttl".equals(format)) {
            finalFormat = "turtle";
        } else if ("n3".equals(format)) {
            finalFormat = "turtle";
        } else if ("n-triples".equals(format) || "ntriples".equals(format) || "nt".equals(format)) {
            finalFormat = "ntriples";
        } else if ("nquads".equals(format) || "n-quads".equals(format) || "nq".equals(format)) {
            finalFormat = "nquads";
        } else if ("trix".equals(format)) {
            finalFormat = "trix";
        } else if ("json".equals(format)) {
            finalFormat = "json";
        } else {
            return null;
        }
        WriterFactory writer = writerRegistry.getWriterByIdentifier(finalFormat);
        return writer;
    }
}

