/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.paxcdi;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.CustomDependencyAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;
import org.ops4j.pax.cdi.api.OsgiService;

public class OsgiServiceHandler
implements CustomDependencyAnnotationHandler<OsgiService> {
    public Class<OsgiService> getAnnotation() {
        return OsgiService.class;
    }

    public String handleDependencyAnnotation(AnnotatedElement annotatedElement, String name, ContextEnricher contextEnricher) {
        ServiceFilter serviceFilter = this.extractServiceFilter(annotatedElement);
        String id = name != null ? name : this.generateReferenceId(this.getClass(annotatedElement), serviceFilter);
        Class<?> clazz = this.getClass(annotatedElement);
        contextEnricher.addBean(id, this.getClass(annotatedElement));
        contextEnricher.addBlueprintContentWriter(this.getWriterId(id, clazz), this.getXmlWriter(id, clazz, serviceFilter));
        return id;
    }

    public String handleDependencyAnnotation(Class<?> clazz, OsgiService annotation, String name, ContextEnricher contextEnricher) {
        ServiceFilter serviceFilter = this.extractServiceFilter(annotation);
        String id = name != null ? name : this.generateReferenceId(clazz, serviceFilter);
        contextEnricher.addBean(id, clazz);
        contextEnricher.addBlueprintContentWriter(this.getWriterId(id, clazz), this.getXmlWriter(id, clazz, serviceFilter));
        return id;
    }

    private XmlWriter getXmlWriter(final String id, final Class<?> clazz, final ServiceFilter serviceFilter) {
        return new XmlWriter(){

            public void write(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeEmptyElement("reference");
                writer.writeAttribute("id", id);
                writer.writeAttribute("interface", clazz.getName());
                if (serviceFilter.filter != null && !"".equals(serviceFilter.filter)) {
                    writer.writeAttribute("filter", serviceFilter.filter);
                }
                if (serviceFilter.compName != null && !"".equals(serviceFilter.compName)) {
                    writer.writeAttribute("component-name", serviceFilter.compName);
                }
            }
        };
    }

    private String getWriterId(String id, Class<?> clazz) {
        return "osgiService/" + clazz.getName() + "/" + id;
    }

    private Class<?> getClass(AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof Class) {
            return (Class)annotatedElement;
        }
        if (annotatedElement instanceof Method) {
            return ((Method)annotatedElement).getParameterTypes()[0];
        }
        if (annotatedElement instanceof Field) {
            return ((Field)annotatedElement).getType();
        }
        throw new RuntimeException("Unknown annotated element");
    }

    private ServiceFilter extractServiceFilter(AnnotatedElement annotatedElement) {
        OsgiService osgiService = annotatedElement.getAnnotation(OsgiService.class);
        return this.extractServiceFilter(osgiService);
    }

    private ServiceFilter extractServiceFilter(OsgiService osgiService) {
        String filterValue = osgiService.filter();
        return new ServiceFilter(filterValue);
    }

    private String generateReferenceId(Class clazz, ServiceFilter serviceFilter) {
        String prefix = OsgiServiceHandler.getBeanNameFromSimpleName(clazz.getSimpleName());
        String suffix = this.createIdSuffix(serviceFilter);
        return prefix + suffix;
    }

    private static String getBeanNameFromSimpleName(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1, name.length());
    }

    private String createIdSuffix(ServiceFilter serviceFilter) {
        if (serviceFilter.filter != null) {
            return "-" + this.getId(serviceFilter.filter);
        }
        if (serviceFilter.compName != null) {
            return "-" + serviceFilter.compName;
        }
        return "";
    }

    private String getId(String raw) {
        StringBuilder builder = new StringBuilder();
        for (int c = 0; c < raw.length(); ++c) {
            char ch = raw.charAt(c);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && (ch < '0' || ch > '9')) continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    private static class ServiceFilter {
        final String filter;
        final String compName;

        ServiceFilter(String filterValue) {
            if (filterValue == null || filterValue.isEmpty()) {
                this.filter = null;
                this.compName = null;
            } else if (filterValue.contains("(")) {
                this.filter = filterValue;
                this.compName = null;
            } else {
                this.filter = null;
                this.compName = filterValue;
            }
        }
    }
}

