/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.paxcdi;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.handlers.paxcdi.ServiceProperty;
import org.apache.aries.blueprint.plugin.spi.BeanAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.BeanEnricher;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;
import org.ops4j.pax.cdi.api.OsgiServiceProvider;
import org.ops4j.pax.cdi.api.Properties;
import org.ops4j.pax.cdi.api.Property;

public class OsgiServiceProviderHandler
implements BeanAnnotationHandler<OsgiServiceProvider> {
    private static final List<String> SPECIAL_PROPERTIES = Collections.singletonList("service.ranking");

    public Class<OsgiServiceProvider> getAnnotation() {
        return OsgiServiceProvider.class;
    }

    public void handleBeanAnnotation(AnnotatedElement annotatedElement, String id, ContextEnricher contextEnricher, BeanEnricher beanEnricher) {
        this.handleAnnotation(annotatedElement, id, contextEnricher);
    }

    private void handleAnnotation(AnnotatedElement annotatedElement, final String id, ContextEnricher contextEnricher) {
        OsgiServiceProvider serviceProvider = annotatedElement.getAnnotation(OsgiServiceProvider.class);
        Properties properties = annotatedElement.getAnnotation(Properties.class);
        final List<String> interfaceNames = OsgiServiceProviderHandler.extractServiceInterfaces(serviceProvider);
        final List<ServiceProperty> serviceProperties = OsgiServiceProviderHandler.extractProperties(properties);
        contextEnricher.addBlueprintContentWriter("OsgiServiceProvider/" + annotatedElement + "/" + id, new XmlWriter(){

            public void write(XMLStreamWriter writer) throws XMLStreamException {
                OsgiServiceProviderHandler.this.writeService(writer, serviceProperties, interfaceNames, id);
            }
        });
    }

    private void writeService(XMLStreamWriter writer, List<ServiceProperty> serviceProperties, List<String> interfaceNames, String id) throws XMLStreamException {
        boolean writeEmptyElement;
        boolean bl = writeEmptyElement = serviceProperties.isEmpty() && interfaceNames.size() < 2;
        if (writeEmptyElement) {
            writer.writeEmptyElement("service");
        } else {
            writer.writeStartElement("service");
        }
        writer.writeAttribute("ref", id);
        if (interfaceNames.size() == 0) {
            writer.writeAttribute("auto-export", "interfaces");
        } else if (interfaceNames.size() == 1) {
            writer.writeAttribute("interface", (String)Iterables.getOnlyElement(interfaceNames));
        } else {
            this.writeInterfacesElement(writer, interfaceNames);
        }
        if (!serviceProperties.isEmpty()) {
            this.writeRanking(writer, serviceProperties);
            this.writeProperties(writer, serviceProperties);
        }
        if (!writeEmptyElement) {
            writer.writeEndElement();
        }
    }

    private static List<ServiceProperty> extractProperties(Properties properties) {
        ArrayList<ServiceProperty> serviceProperties = new ArrayList<ServiceProperty>();
        if (properties != null) {
            for (Property property : properties.value()) {
                serviceProperties.add(new ServiceProperty(property.name(), property.value()));
            }
        }
        return serviceProperties;
    }

    private static List<String> extractServiceInterfaces(OsgiServiceProvider serviceProvider) {
        ArrayList interfaceNames = Lists.newArrayList();
        for (Class serviceIf : serviceProvider.classes()) {
            interfaceNames.add(serviceIf.getName());
        }
        return interfaceNames;
    }

    private void writeInterfacesElement(XMLStreamWriter writer, Iterable<String> interfaceNames) throws XMLStreamException {
        writer.writeStartElement("interfaces");
        for (String interfaceName : interfaceNames) {
            writer.writeStartElement("value");
            writer.writeCharacters(interfaceName);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeRanking(XMLStreamWriter writer, List<ServiceProperty> serviceProperties) throws XMLStreamException {
        for (ServiceProperty serviceProperty : serviceProperties) {
            if (!"service.ranking".equals(serviceProperty.name)) continue;
            try {
                Integer ranking = Integer.parseInt(serviceProperty.getSingleValue());
                writer.writeAttribute("ranking", ranking.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("service.ranking property must be an integer!");
            }
        }
    }

    private void writeProperties(XMLStreamWriter writer, List<ServiceProperty> serviceProperties) throws XMLStreamException {
        writer.writeStartElement("service-properties");
        for (ServiceProperty serviceProperty : serviceProperties) {
            if (SPECIAL_PROPERTIES.contains(serviceProperty.name)) continue;
            serviceProperty.write(writer);
        }
        writer.writeEndElement();
    }
}

