/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.spring;

import com.google.common.base.CaseFormat;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.spi.BeanAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.BeanEnricher;
import org.apache.aries.blueprint.plugin.spi.BlueprintConfiguration;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.MethodAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class SpringTransactionalFactory
implements BeanAnnotationHandler<Transactional>,
MethodAnnotationHandler<Transactional> {
    private static final String PATTERN_NS_TX1 = "http\\:\\/\\/aries\\.apache\\.org\\/xmlns\\/transactions\\/v1\\.(.)\\.(.)";
    private static final String PATTERN_NS_TX2 = "http\\:\\/\\/aries\\.apache\\.org\\/xmlns\\/transactions\\/v2\\.(.)\\.(.)";
    private static final String NS_TX_1_2_0 = "http://aries.apache.org/xmlns/transactions/v1.2.0";
    private static final String ENABLE_ANNOTATION = "transaction.enableAnnotation";

    private String getTransactionTypeName(Transactional transactional) {
        Propagation propagation = transactional.propagation();
        if (propagation == Propagation.NESTED) {
            throw new UnsupportedOperationException("Nested transactions not supported");
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, propagation.name());
    }

    public Class<Transactional> getAnnotation() {
        return Transactional.class;
    }

    public void handleMethodAnnotation(Class<?> clazz, List<Method> methods, ContextEnricher contextEnricher, BeanEnricher beanEnricher) {
        String nsTx2;
        final String nsTx1 = this.getNamespaceByPattern(contextEnricher.getBlueprintConfiguration().getNamespaces(), PATTERN_NS_TX1);
        if (nsTx1 != null) {
            this.enableAnnotationTx1(contextEnricher, nsTx1);
            for (Method method : methods) {
                Transactional transactional = method.getAnnotation(Transactional.class);
                final String transactionTypeName = this.getTransactionTypeName(transactional);
                final String name = method.getName();
                beanEnricher.addBeanContentWriter("javax.transactional.method/" + clazz.getName() + "/" + name + "/" + transactionTypeName, new XmlWriter(){

                    public void write(XMLStreamWriter writer) throws XMLStreamException {
                        writer.writeEmptyElement("transaction");
                        writer.writeDefaultNamespace(nsTx1);
                        writer.writeAttribute("method", name);
                        writer.writeAttribute("value", transactionTypeName);
                    }
                });
            }
        }
        if ((nsTx2 = this.getNamespaceByPattern(contextEnricher.getBlueprintConfiguration().getNamespaces(), PATTERN_NS_TX2)) != null) {
            this.insertEnableAnnotationTx2(contextEnricher, nsTx2);
        }
    }

    public void handleBeanAnnotation(AnnotatedElement annotatedElement, String id, ContextEnricher contextEnricher, BeanEnricher beanEnricher) {
        String nsTx2;
        final String nsTx1 = this.getNamespaceByPattern(contextEnricher.getBlueprintConfiguration().getNamespaces(), PATTERN_NS_TX1);
        if (nsTx1 != null) {
            this.enableAnnotationTx1(contextEnricher, nsTx1);
            Transactional transactional = annotatedElement.getAnnotation(Transactional.class);
            final String transactionTypeName = this.getTransactionTypeName(transactional);
            beanEnricher.addBeanContentWriter("javax.transactional.method/" + annotatedElement + "/*/" + transactionTypeName, new XmlWriter(){

                public void write(XMLStreamWriter writer) throws XMLStreamException {
                    writer.writeEmptyElement("transaction");
                    writer.writeDefaultNamespace(nsTx1);
                    writer.writeAttribute("method", "*");
                    writer.writeAttribute("value", transactionTypeName);
                }
            });
        }
        if ((nsTx2 = this.getNamespaceByPattern(contextEnricher.getBlueprintConfiguration().getNamespaces(), PATTERN_NS_TX1)) != null) {
            this.insertEnableAnnotationTx2(contextEnricher, nsTx2);
        }
    }

    private String getNamespaceByPattern(Set<String> namespaces, String pattern) {
        for (String namespace : namespaces) {
            if (!namespace.matches(pattern)) continue;
            return namespace;
        }
        return null;
    }

    private void enableAnnotationTx1(ContextEnricher contextEnricher, String nsTx1) {
        if (NS_TX_1_2_0.equals(nsTx1) && this.getEnableAnnotationConfig(contextEnricher.getBlueprintConfiguration())) {
            this.insertEnableAnnotationTx1(contextEnricher, nsTx1);
        }
    }

    private boolean getEnableAnnotationConfig(BlueprintConfiguration blueprintConfig) {
        String enableAnnotation = (String)blueprintConfig.getCustomParameters().get(ENABLE_ANNOTATION);
        return enableAnnotation == null || Boolean.parseBoolean(enableAnnotation);
    }

    private void insertEnableAnnotationTx1(ContextEnricher contextEnricher, final String namespace) {
        contextEnricher.addBlueprintContentWriter("transaction/ennable-annotation", new XmlWriter(){

            public void write(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeEmptyElement("enable-annotations");
                writer.writeDefaultNamespace(namespace);
            }
        });
    }

    private void insertEnableAnnotationTx2(ContextEnricher contextEnricher, final String namespace) {
        contextEnricher.addBlueprintContentWriter("transaction/ennable-annotation", new XmlWriter(){

            public void write(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeEmptyElement("enable");
                writer.writeDefaultNamespace(namespace);
            }
        });
    }
}

