/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;

class ArtifactFilter {
    private final Set<Pattern> includeArtifactPatterns;
    private final Set<Pattern> excludeArtifactPatterns;

    ArtifactFilter(Set<String> includeArtifacts, Set<String> excludeArtifacts) {
        this.includeArtifactPatterns = this.buildArtifactPatterns(includeArtifacts);
        this.excludeArtifactPatterns = this.buildPatterns(excludeArtifacts);
    }

    boolean shouldExclude(Artifact artifact) {
        return !this.canBeIncluded(artifact) || this.shouldBeExcluded(artifact);
    }

    private Set<Pattern> buildArtifactPatterns(Set<String> includeArtifacts) {
        if (includeArtifacts.isEmpty()) {
            HashSet<Pattern> patterns = new HashSet<Pattern>();
            patterns.add(Pattern.compile(".*"));
            return patterns;
        }
        return this.buildPatterns(includeArtifacts);
    }

    private Set<Pattern> buildPatterns(Set<String> artifactFilters) {
        HashSet<Pattern> artifactPatterns = new HashSet<Pattern>();
        for (String artifactFilter : artifactFilters) {
            artifactPatterns.add(Pattern.compile(artifactFilter));
        }
        return artifactPatterns;
    }

    private boolean shouldBeExcluded(Artifact artifact) {
        for (Pattern excludeArtifactPattern : this.excludeArtifactPatterns) {
            if (!excludeArtifactPattern.matcher(artifact.toString()).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean canBeIncluded(Artifact artifact) {
        for (Pattern includeArtifactPattern : this.includeArtifactPatterns) {
            if (!includeArtifactPattern.matcher(artifact.toString()).matches()) continue;
            return true;
        }
        return false;
    }
}

