/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.aries.blueprint.plugin.NegativeTimeout;
import org.apache.aries.blueprint.plugin.spi.Activation;
import org.apache.aries.blueprint.plugin.spi.Availability;
import org.apache.aries.blueprint.plugin.spi.BlueprintConfiguration;

public class BlueprintConfigurationImpl
implements BlueprintConfiguration {
    private static final String NS_TX2 = "http://aries.apache.org/xmlns/transactions/v2.0.0";
    private static final String NS_JPA2 = "http://aries.apache.org/xmlns/jpa/v2.0.0";
    private final Set<String> namespaces;
    private final Activation defaultActivation;
    private final Map<String, String> customParameters;
    private final Availability defaultAvailability;
    private final Long defaultTimeout;

    public BlueprintConfigurationImpl(Set<String> namespaces, Activation defaultActivation, Map<String, String> customParameters, Availability defaultAvailability, Long defaultTimeout) {
        this.namespaces = namespaces != null ? namespaces : new HashSet<String>(Arrays.asList(NS_TX2, NS_JPA2));
        this.defaultActivation = defaultActivation;
        this.customParameters = customParameters == null ? new HashMap() : customParameters;
        this.defaultAvailability = defaultAvailability;
        this.defaultTimeout = defaultTimeout;
        this.validateTimeout();
    }

    private void validateTimeout() {
        if (this.defaultTimeout != null && this.defaultTimeout < 0L) {
            throw new NegativeTimeout(this.defaultTimeout);
        }
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    public Activation getDefaultActivation() {
        return this.defaultActivation;
    }

    public Availability getDefaultAvailability() {
        return this.defaultAvailability;
    }

    public Long getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }
}

