/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.aries.blueprint.plugin.model.Blueprint;

class BlueprintFileWriter {
    private final XMLStreamWriter writer;
    private final OutputStream os;
    private final ByteArrayOutputStream temp = new ByteArrayOutputStream();

    BlueprintFileWriter(OutputStream os) throws XMLStreamException {
        this.writer = XMLOutputFactory.newFactory().createXMLStreamWriter(this.temp);
        this.os = os;
    }

    void write(Blueprint blueprint) {
        this.generateXml(blueprint);
        this.printFormatted();
    }

    private void generateXml(Blueprint blueprint) {
        try {
            this.writer.writeStartDocument();
            blueprint.write(this.writer);
            this.writer.writeEndDocument();
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void printFormatted() {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new StreamSource(new ByteArrayInputStream(this.temp.toByteArray())), new StreamResult(this.os));
        }
        catch (TransformerException e) {
            throw new RuntimeException("Cannot print file", e);
        }
    }
}

