/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin;

import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.aries.blueprint.plugin.ArtifactFilter;
import org.apache.aries.blueprint.plugin.BlueprintConfigurationImpl;
import org.apache.aries.blueprint.plugin.BlueprintFileWriter;
import org.apache.aries.blueprint.plugin.FilteredClassFinder;
import org.apache.aries.blueprint.plugin.PackageFinder;
import org.apache.aries.blueprint.plugin.ResourceInitializer;
import org.apache.aries.blueprint.plugin.model.Blueprint;
import org.apache.aries.blueprint.plugin.model.ConflictDetected;
import org.apache.aries.blueprint.plugin.spi.Activation;
import org.apache.aries.blueprint.plugin.spi.Availability;
import org.apache.aries.blueprint.plugin.spi.BlueprintConfiguration;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.xbean.finder.ClassFinder;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="blueprint-generate", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_CLASSES, inheritByDefault=false, threadSafe=true)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true)
    protected MavenProject project;
    @Parameter
    protected List<String> scanPaths;
    @Parameter
    protected Set<String> namespaces;
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="autowire.xml")
    protected String generatedFileName;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/blueprint/")
    private String baseDir;
    @Parameter(defaultValue="OSGI-INF/blueprint/")
    private String generatedDir;
    @Parameter
    protected Activation defaultActivation;
    @Parameter
    protected Availability defaultAvailability;
    @Parameter
    protected Long defaultTimeout;
    @Parameter
    protected Map<String, String> customParameters;
    @Parameter
    private Set<String> includeArtifacts = new HashSet<String>();
    @Parameter
    private Set<String> excludeArtifacts = new HashSet<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<String> toScan = this.getPackagesToScan();
        if (!this.sourcesChanged()) {
            this.getLog().info((CharSequence)"Skipping blueprint generation because source files were not changed");
            return;
        }
        try {
            BlueprintConfigurationImpl blueprintConfiguration = new BlueprintConfigurationImpl(this.namespaces, this.defaultActivation, this.customParameters, this.defaultAvailability, this.defaultTimeout);
            this.generateBlueprint(toScan, blueprintConfiguration);
        }
        catch (ConflictDetected e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during blueprint generation", e);
        }
    }

    private void generateBlueprint(List<String> toScan, BlueprintConfigurationImpl blueprintConfiguration) throws Exception {
        long startTime = System.currentTimeMillis();
        ClassFinder classFinder = this.createProjectScopeFinder();
        this.getLog().debug((CharSequence)("Creating package scope class finder: " + (System.currentTimeMillis() - startTime) + "ms"));
        startTime = System.currentTimeMillis();
        Set<Class<?>> classes = FilteredClassFinder.findClasses(classFinder, toScan);
        this.getLog().debug((CharSequence)("Finding bean classes: " + (System.currentTimeMillis() - startTime) + "ms"));
        startTime = System.currentTimeMillis();
        Blueprint blueprint = new Blueprint((BlueprintConfiguration)blueprintConfiguration, classes);
        this.getLog().debug((CharSequence)("Creating blueprint model: " + (System.currentTimeMillis() - startTime) + "ms"));
        startTime = System.currentTimeMillis();
        this.writeBlueprintIfNeeded(blueprint);
        this.getLog().debug((CharSequence)("Writing blueprint: " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private void writeBlueprintIfNeeded(Blueprint blueprint) throws Exception {
        if (blueprint.shouldBeGenerated()) {
            this.writeBlueprint(blueprint);
        } else {
            this.getLog().warn((CharSequence)"Skipping blueprint generation because no beans were found");
        }
    }

    private boolean sourcesChanged() {
        return this.buildContext.hasDelta(new File((String)this.project.getCompileSourceRoots().iterator().next()));
    }

    private void writeBlueprint(Blueprint blueprint) throws Exception {
        ResourceInitializer.prepareBaseDir(this.project, this.baseDir);
        File dir = new File(this.baseDir, this.generatedDir);
        File file = new File(dir, this.generatedFileName);
        file.getParentFile().mkdirs();
        this.getLog().info((CharSequence)("Generating blueprint to " + file));
        OutputStream fos = this.buildContext.newFileOutputStream(file);
        new BlueprintFileWriter(fos).write(blueprint);
        fos.close();
    }

    private ClassFinder createProjectScopeFinder() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        long startTime = System.currentTimeMillis();
        ClassRealm classRealm = new ClassRealm(new ClassWorld(), "maven-blueprint-plugin-classloader", ((Object)((Object)this)).getClass().getClassLoader());
        classRealm.addURL(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
        urls.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
        ArtifactFilter artifactFilter = new ArtifactFilter(this.includeArtifacts, this.excludeArtifacts);
        for (Object artifactO : this.project.getArtifacts()) {
            Artifact artifact = (Artifact)artifactO;
            File file = artifact.getFile();
            if (file == null) continue;
            URL artifactUrl = file.toURI().toURL();
            classRealm.addURL(artifactUrl);
            if (artifactFilter.shouldExclude(artifact)) {
                this.getLog().debug((CharSequence)("Excluded artifact: " + artifact));
                continue;
            }
            this.getLog().debug((CharSequence)("Taken artifact: " + artifact));
            urls.add(artifactUrl);
        }
        this.getLog().debug((CharSequence)(" Create class loader: " + (System.currentTimeMillis() - startTime) + "ms"));
        startTime = System.currentTimeMillis();
        ClassFinder classFinder = new ClassFinder((ClassLoader)classRealm, urls);
        this.getLog().debug((CharSequence)(" Building class finder: " + (System.currentTimeMillis() - startTime) + "ms"));
        return classFinder;
    }

    private List<String> getPackagesToScan() throws MojoExecutionException {
        List<String> toScan = this.scanPaths;
        if (this.scanPaths == null || this.scanPaths.size() == 0 || this.scanPaths.iterator().next() == null) {
            this.getLog().info((CharSequence)"Scan paths not specified - searching for packages");
            Set<String> packages = PackageFinder.findPackagesInSources(this.project.getCompileSourceRoots());
            if (packages.contains(null)) {
                throw new MojoExecutionException("Found file without package");
            }
            toScan = new ArrayList<String>(packages);
            Collections.sort(toScan);
        }
        for (String aPackage : toScan) {
            this.getLog().info((CharSequence)("Package " + aPackage + " will be scanned"));
        }
        return toScan;
    }
}

