/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

class PackageFinder {
    PackageFinder() {
    }

    static Set<String> findPackagesInSources(List<String> compileSourceRoots) {
        HashSet<String> packages = new HashSet<String>();
        for (String src : compileSourceRoots) {
            File root = new File(src);
            if (!root.exists()) continue;
            packages.addAll(PackageFinder.findPackageRoots(root));
        }
        return packages;
    }

    private static Set<String> findPackageRoots(File file) {
        HashSet<String> packages = new HashSet<String>();
        Stack<SearchFile> stack = new Stack<SearchFile>();
        stack.add(new SearchFile(null, file));
        while (!stack.isEmpty()) {
            SearchFile cur = (SearchFile)stack.pop();
            File[] files = cur.f.listFiles();
            boolean foundFile = false;
            for (File child : files) {
                if (!child.isFile()) continue;
                packages.add(cur.prefix);
                foundFile = true;
            }
            if (foundFile) continue;
            for (File child : files) {
                if (!child.isDirectory()) continue;
                stack.add(new SearchFile(cur.prefix != null ? cur.prefix + "." + child.getName() : child.getName(), child));
            }
        }
        return packages;
    }

    private static class SearchFile {
        String prefix;
        File f;

        SearchFile(String prefix, File f) {
            this.prefix = prefix;
            this.f = f;
        }
    }
}

