/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.blueprint.config;

import java.lang.reflect.AnnotatedElement;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.annotation.config.ConfigProperties;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.CustomDependencyAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

public class ConfigPropertiesHandler
implements CustomDependencyAnnotationHandler<ConfigProperties> {
    public String handleDependencyAnnotation(AnnotatedElement annotatedElement, String name, ContextEnricher contextEnricher) {
        ConfigProperties configProperties = annotatedElement.getAnnotation(ConfigProperties.class);
        String pid = configProperties.pid();
        boolean update = configProperties.update();
        String id = this.getId(name, pid, update);
        this.enrichContext(contextEnricher, pid, update, id);
        return id;
    }

    private void enrichContext(ContextEnricher contextEnricher, final String pid, final boolean update, final String id) {
        contextEnricher.addBean(id, Properties.class);
        contextEnricher.addBlueprintContentWriter("properties/" + id, new XmlWriter(){

            public void write(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeEmptyElement("cm-properties");
                writer.writeDefaultNamespace("http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.2.0");
                writer.writeAttribute("id", id);
                writer.writeAttribute("persistent-id", pid);
                writer.writeAttribute("update", String.valueOf(update));
            }
        });
    }

    public String handleDependencyAnnotation(Class<?> aClass, ConfigProperties configProperties, String name, ContextEnricher contextEnricher) {
        String pid = configProperties.pid();
        boolean update = configProperties.update();
        String id = this.getId(name, pid, update);
        this.enrichContext(contextEnricher, pid, update, id);
        return id;
    }

    private String getId(String name, String pid, boolean update) {
        return name != null ? name : "properties-" + pid.replace('.', '-') + "-" + update;
    }

    public Class<ConfigProperties> getAnnotation() {
        return ConfigProperties.class;
    }
}

