/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.blueprint.config;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.annotation.config.Config;
import org.apache.aries.blueprint.annotation.config.DefaultProperty;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

class ConfigWriter
implements XmlWriter {
    private static final String CONFIG_NS = "http://aries.apache.org/blueprint/xmlns/blueprint-cm/v1.1.0";
    private Config config;

    ConfigWriter(Config config) {
        this.config = config;
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("property-placeholder");
        writer.writeDefaultNamespace(CONFIG_NS);
        writer.writeAttribute("persistent-id", this.config.pid());
        if (!"${".equals(this.config.placeholderPrefix())) {
            writer.writeAttribute("placeholder-prefix", this.config.placeholderPrefix());
        }
        if (!"}".equals(this.config.placeholderSuffix())) {
            writer.writeAttribute("placeholder-suffix", this.config.placeholderSuffix());
        }
        writer.writeAttribute("update-strategy", this.config.updatePolicy());
        DefaultProperty[] defaults = this.config.defaults();
        if (defaults.length > 0) {
            writer.writeStartElement("default-properties");
            for (DefaultProperty defaultProp : defaults) {
                writer.writeEmptyElement("property");
                writer.writeAttribute("name", defaultProp.key());
                writer.writeAttribute("value", defaultProp.value());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

