/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.blueprint.referencelistener;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.annotation.referencelistener.Bind;
import org.apache.aries.blueprint.annotation.referencelistener.Cardinality;
import org.apache.aries.blueprint.annotation.referencelistener.ReferenceListener;
import org.apache.aries.blueprint.annotation.referencelistener.Unbind;
import org.apache.aries.blueprint.plugin.handlers.blueprint.referencelistener.ReferenceListenerDefinition;
import org.apache.aries.blueprint.plugin.spi.BeanAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.BeanEnricher;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

public class ReferenceListenerHandler
implements BeanAnnotationHandler<ReferenceListener> {
    public void handleBeanAnnotation(AnnotatedElement annotatedElement, String id, ContextEnricher contextEnricher, BeanEnricher beanEnricher) {
        String referenceBeanName;
        ReferenceListener annotation = annotatedElement.getAnnotation(ReferenceListener.class);
        Class<?> referenceListenerClass = this.getClass(annotatedElement);
        String bindMethod = annotation.bindMethod().isEmpty() ? this.getAnnotatedMethodName(referenceListenerClass, Bind.class) : annotation.bindMethod();
        String unbindMethod = annotation.unbindMethod().isEmpty() ? this.getAnnotatedMethodName(referenceListenerClass, Unbind.class) : annotation.unbindMethod();
        ReferenceListenerDefinition referenceListenerDefinition = new ReferenceListenerDefinition(id, bindMethod, unbindMethod);
        String string = referenceBeanName = annotation.referenceName().isEmpty() ? this.createReferenceBeanName(annotation) : annotation.referenceName();
        if (annotation.cardinality() == Cardinality.SINGLE) {
            contextEnricher.addBean(referenceBeanName, annotation.referenceInterface());
            this.createReference(referenceBeanName, referenceListenerDefinition, annotation, contextEnricher);
        } else {
            contextEnricher.addBean(referenceBeanName, List.class);
            this.createReferenceList(referenceBeanName, referenceListenerDefinition, annotation, contextEnricher);
        }
    }

    private void createReference(final String referenceBeanName, final ReferenceListenerDefinition referenceListenerDefinition, final ReferenceListener annotation, ContextEnricher contextEnricher) {
        contextEnricher.addBlueprintContentWriter("referenceWithReferenceListener/" + referenceBeanName + "/" + referenceListenerDefinition.ref, new XmlWriter(){

            public void write(XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
                xmlStreamWriter.writeStartElement("reference");
                xmlStreamWriter.writeAttribute("interface", annotation.referenceInterface().getName());
                xmlStreamWriter.writeAttribute("availability", annotation.availability().name().toLowerCase());
                xmlStreamWriter.writeAttribute("id", referenceBeanName);
                if (!annotation.filter().isEmpty()) {
                    xmlStreamWriter.writeAttribute("filter", annotation.filter());
                }
                if (!annotation.componentName().isEmpty()) {
                    xmlStreamWriter.writeAttribute("component-name", annotation.componentName());
                }
                ReferenceListenerHandler.this.writeReferenceListner(xmlStreamWriter, referenceListenerDefinition);
                xmlStreamWriter.writeEndElement();
            }
        });
    }

    private void createReferenceList(final String referenceBeanName, final ReferenceListenerDefinition referenceListenerDefinition, final ReferenceListener annotation, ContextEnricher contextEnricher) {
        contextEnricher.addBlueprintContentWriter("referenceListWithReferenceListener/" + referenceBeanName + "/" + referenceListenerDefinition.ref, new XmlWriter(){

            public void write(XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
                xmlStreamWriter.writeStartElement("reference-list");
                xmlStreamWriter.writeAttribute("interface", annotation.referenceInterface().getName());
                xmlStreamWriter.writeAttribute("availability", annotation.availability().name().toLowerCase());
                xmlStreamWriter.writeAttribute("id", referenceBeanName);
                if (!annotation.filter().isEmpty()) {
                    xmlStreamWriter.writeAttribute("filter", annotation.filter());
                }
                if (!annotation.componentName().isEmpty()) {
                    xmlStreamWriter.writeAttribute("component-name", annotation.componentName());
                }
                ReferenceListenerHandler.this.writeReferenceListner(xmlStreamWriter, referenceListenerDefinition);
                xmlStreamWriter.writeEndElement();
            }
        });
    }

    private void writeReferenceListner(XMLStreamWriter xmlStreamWriter, ReferenceListenerDefinition referenceListenerDefinition) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("reference-listener");
        xmlStreamWriter.writeAttribute("ref", referenceListenerDefinition.ref);
        if (referenceListenerDefinition.bind != null) {
            xmlStreamWriter.writeAttribute("bind-method", referenceListenerDefinition.bind);
        }
        if (referenceListenerDefinition.unbind != null) {
            xmlStreamWriter.writeAttribute("unbind-method", referenceListenerDefinition.unbind);
        }
        xmlStreamWriter.writeEndElement();
    }

    private String createReferenceBeanName(ReferenceListener annotation) {
        String prefix = ReferenceListenerHandler.getBeanNameFromSimpleName(annotation.referenceInterface().getSimpleName());
        String listPart = annotation.cardinality() == Cardinality.SINGLE ? "" : "List";
        String suffix = this.createIdSuffix(annotation);
        return prefix + listPart + suffix;
    }

    private static String getBeanNameFromSimpleName(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1, name.length());
    }

    private String createIdSuffix(ReferenceListener listener) {
        return this.createComponentNamePart(listener) + this.createFilterPart(listener);
    }

    private String createComponentNamePart(ReferenceListener listener) {
        if (!listener.componentName().isEmpty()) {
            return "-" + listener.componentName();
        }
        return "";
    }

    private String createFilterPart(ReferenceListener listener) {
        if (!listener.filter().isEmpty()) {
            return "-" + this.getId(listener.filter());
        }
        return "";
    }

    private String getId(String raw) {
        StringBuilder builder = new StringBuilder();
        for (int c = 0; c < raw.length(); ++c) {
            char ch = raw.charAt(c);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && (ch < '0' || ch > '9')) continue;
            builder.append(ch);
        }
        return builder.toString();
    }

    private String getAnnotatedMethodName(Class<?> referenceListenerClass, Class annotation) {
        for (Method method : referenceListenerClass.getMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            return method.getName();
        }
        return null;
    }

    public Class<ReferenceListener> getAnnotation() {
        return ReferenceListener.class;
    }

    private Class<?> getClass(AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof Class) {
            return (Class)annotatedElement;
        }
        if (annotatedElement instanceof Method) {
            return ((Method)annotatedElement).getReturnType();
        }
        throw new RuntimeException("Unknown annotated element");
    }
}

