/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.blueprint.service;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.annotation.service.Reference;
import org.apache.aries.blueprint.plugin.handlers.blueprint.service.ReferenceId;
import org.apache.aries.blueprint.plugin.handlers.blueprint.service.ReferenceParameters;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.CustomDependencyAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

public class ReferenceHandler
implements CustomDependencyAnnotationHandler<Reference> {
    public Class<Reference> getAnnotation() {
        return Reference.class;
    }

    public String handleDependencyAnnotation(AnnotatedElement annotatedElement, String name, ContextEnricher contextEnricher) {
        Reference reference = annotatedElement.getAnnotation(Reference.class);
        Class<?> clazz = this.getClass(annotatedElement);
        return this.handleDependencyAnnotation(clazz, reference, name, contextEnricher);
    }

    public String handleDependencyAnnotation(Class<?> clazz, Reference reference, String name, ContextEnricher contextEnricher) {
        String id = name != null ? name : ReferenceId.generateReferenceId(clazz, reference, contextEnricher);
        contextEnricher.addBean(id, clazz);
        contextEnricher.addBlueprintContentWriter(this.getWriterId(id, clazz), this.getXmlWriter(id, clazz, reference, contextEnricher));
        return id;
    }

    private XmlWriter getXmlWriter(final String id, final Class<?> clazz, final Reference reference, final ContextEnricher contextEnricher) {
        return new XmlWriter(){

            public void write(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeEmptyElement("reference");
                writer.writeAttribute("id", id);
                writer.writeAttribute("interface", clazz.getName());
                if (!"".equals(reference.filter())) {
                    writer.writeAttribute("filter", reference.filter());
                }
                if (!"".equals(reference.componentName())) {
                    writer.writeAttribute("component-name", reference.componentName());
                }
                if (ReferenceParameters.needTimeout(reference.timeout())) {
                    writer.writeAttribute("timeout", String.valueOf(reference.timeout()));
                }
                if (ReferenceParameters.needAvailability(contextEnricher, reference.availability())) {
                    writer.writeAttribute("availability", reference.availability().name().toLowerCase());
                }
            }
        };
    }

    private String getWriterId(String id, Class<?> clazz) {
        return "reference/" + clazz.getName() + "/" + id;
    }

    private Class<?> getClass(AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof Class) {
            return (Class)annotatedElement;
        }
        if (annotatedElement instanceof Method) {
            return ((Method)annotatedElement).getParameterTypes()[0];
        }
        if (annotatedElement instanceof Field) {
            return ((Field)annotatedElement).getType();
        }
        throw new RuntimeException("Unknown annotated element");
    }
}

