/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.blueprint.service;

import org.apache.aries.blueprint.annotation.service.Availability;
import org.apache.aries.blueprint.annotation.service.MemberType;
import org.apache.aries.blueprint.annotation.service.Reference;
import org.apache.aries.blueprint.annotation.service.ReferenceList;
import org.apache.aries.blueprint.plugin.handlers.blueprint.service.ReferenceParameters;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;

class ReferenceId {
    ReferenceId() {
    }

    static String generateReferenceId(Class clazz, Reference reference, ContextEnricher contextEnricher) {
        StringBuilder sb = new StringBuilder();
        ReferenceId.writeBeanNameFromSimpleName(sb, clazz.getSimpleName());
        ReferenceId.appendFilter(sb, reference.filter());
        ReferenceId.appendComponentName(sb, reference.componentName());
        ReferenceId.appendAvailability(sb, reference.availability(), contextEnricher);
        ReferenceId.appendTimeout(sb, reference.timeout());
        return sb.toString().replaceAll("-+$", "");
    }

    private static void appendTimeout(StringBuilder sb, long timeout) {
        sb.append("-");
        if (ReferenceParameters.needTimeout(timeout)) {
            sb.append(timeout);
        }
    }

    private static void appendAvailability(StringBuilder sb, Availability availability, ContextEnricher contextEnricher) {
        sb.append("-");
        if (ReferenceParameters.needAvailability(contextEnricher, availability)) {
            sb.append(availability.name().toLowerCase());
        }
    }

    private static void appendComponentName(StringBuilder sb, String componentName) {
        sb.append("-");
        if (!"".equals(componentName)) {
            sb.append(componentName);
        }
    }

    private static void appendFilter(StringBuilder sb, String filter) {
        sb.append("-");
        if (!"".equals(filter)) {
            ReferenceId.writeEscapedFilter(sb, filter);
        }
    }

    static String generateReferenceListId(ReferenceList referenceList, ContextEnricher contextEnricher) {
        StringBuilder sb = new StringBuilder("listOf-");
        ReferenceId.writeBeanNameFromSimpleName(sb, referenceList.referenceInterface().getSimpleName());
        ReferenceId.appendFilter(sb, referenceList.filter());
        ReferenceId.appendComponentName(sb, referenceList.componentName());
        ReferenceId.appendAvailability(sb, referenceList.availability(), contextEnricher);
        ReferenceId.appendMemberType(sb, referenceList.memberType());
        return sb.toString().replaceAll("-+$", "");
    }

    private static void appendMemberType(StringBuilder sb, MemberType memberType) {
        sb.append("-");
        if (memberType == MemberType.SERVICE_REFERENCE) {
            sb.append("reference");
        }
    }

    private static void writeBeanNameFromSimpleName(StringBuilder sb, String name) {
        sb.append(name.substring(0, 1).toLowerCase());
        sb.append(name.substring(1, name.length()));
    }

    private static void writeEscapedFilter(StringBuilder sb, String filter) {
        for (int c = 0; c < filter.length(); ++c) {
            char ch = filter.charAt(c);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && (ch < '0' || ch > '9')) continue;
            sb.append(ch);
        }
    }
}

