/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.blueprint.service;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.annotation.service.MemberType;
import org.apache.aries.blueprint.annotation.service.ReferenceList;
import org.apache.aries.blueprint.plugin.handlers.blueprint.service.ReferenceId;
import org.apache.aries.blueprint.plugin.handlers.blueprint.service.ReferenceListInvalidInterface;
import org.apache.aries.blueprint.plugin.handlers.blueprint.service.ReferenceParameters;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.CustomDependencyAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

public class ReferenceListHandler
implements CustomDependencyAnnotationHandler<ReferenceList> {
    public Class<ReferenceList> getAnnotation() {
        return ReferenceList.class;
    }

    public String handleDependencyAnnotation(AnnotatedElement annotatedElement, String name, ContextEnricher contextEnricher) {
        ReferenceList referenceList = annotatedElement.getAnnotation(ReferenceList.class);
        Class<?> clazz = this.getClass(annotatedElement);
        return this.handleDependencyAnnotation(clazz, referenceList, name, contextEnricher);
    }

    public String handleDependencyAnnotation(Class<?> clazz, ReferenceList referenceList, String name, ContextEnricher contextEnricher) {
        if (clazz != List.class) {
            throw new ReferenceListInvalidInterface(clazz);
        }
        String id = name != null ? name : ReferenceId.generateReferenceListId(referenceList, contextEnricher);
        contextEnricher.addBean(id, clazz);
        contextEnricher.addBlueprintContentWriter(this.getWriterId(id, referenceList.referenceInterface()), this.getXmlWriter(id, referenceList, contextEnricher));
        return id;
    }

    private XmlWriter getXmlWriter(final String id, final ReferenceList referenceList, final ContextEnricher contextEnricher) {
        return new XmlWriter(){

            public void write(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeEmptyElement("reference-list");
                writer.writeAttribute("id", id);
                writer.writeAttribute("interface", referenceList.referenceInterface().getName());
                if (!"".equals(referenceList.filter())) {
                    writer.writeAttribute("filter", referenceList.filter());
                }
                if (!"".equals(referenceList.componentName())) {
                    writer.writeAttribute("component-name", referenceList.componentName());
                }
                if (ReferenceParameters.needAvailability(contextEnricher, referenceList.availability())) {
                    writer.writeAttribute("availability", referenceList.availability().name().toLowerCase());
                }
                if (referenceList.memberType() == MemberType.SERVICE_REFERENCE) {
                    writer.writeAttribute("member-type", "service-reference");
                }
            }
        };
    }

    private String getWriterId(String id, Class<?> clazz) {
        return "referenceList/" + clazz.getName() + "/" + id;
    }

    private Class<?> getClass(AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof Class) {
            return (Class)annotatedElement;
        }
        if (annotatedElement instanceof Method) {
            return ((Method)annotatedElement).getParameterTypes()[0];
        }
        if (annotatedElement instanceof Field) {
            return ((Field)annotatedElement).getType();
        }
        throw new RuntimeException("Unknown annotated element");
    }
}

