/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.blueprint.service;

import java.lang.reflect.AnnotatedElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.annotation.service.AutoExport;
import org.apache.aries.blueprint.annotation.service.Service;
import org.apache.aries.blueprint.plugin.handlers.blueprint.service.ServicePropertyWriter;
import org.apache.aries.blueprint.plugin.spi.BeanAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.BeanEnricher;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

public class ServiceHandler
implements BeanAnnotationHandler<Service> {
    public Class<Service> getAnnotation() {
        return Service.class;
    }

    public void handleBeanAnnotation(AnnotatedElement annotatedElement, final String id, ContextEnricher contextEnricher, BeanEnricher beanEnricher) {
        final Service annotation = annotatedElement.getAnnotation(Service.class);
        contextEnricher.addBlueprintContentWriter("service/" + id, new XmlWriter(){

            public void write(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeStartElement("service");
                writer.writeAttribute("ref", id);
                ServiceHandler.this.writeRanking(writer, annotation);
                ServiceHandler.this.writeExportSpecification(writer, annotation);
                new ServicePropertyWriter(annotation.properties(), annotation.ranking()).writeProperties(writer);
                writer.writeEndElement();
            }
        });
    }

    private void writeRanking(XMLStreamWriter writer, Service annotation) throws XMLStreamException {
        if (annotation.ranking() != 0) {
            writer.writeAttribute("ranking", String.valueOf(annotation.ranking()));
        }
    }

    private void writeExportSpecification(XMLStreamWriter writer, Service annotation) throws XMLStreamException {
        if (annotation.classes().length == 0) {
            if (annotation.autoExport() != AutoExport.DISABLED) {
                writer.writeAttribute("auto-export", this.autoExport(annotation.autoExport()));
            }
        } else if (annotation.classes().length == 1) {
            writer.writeAttribute("interface", annotation.classes()[0].getName());
        } else {
            this.writeInterfaces(writer, annotation.classes());
        }
    }

    private String autoExport(AutoExport autoExport) {
        switch (autoExport) {
            case INTERFACES: {
                return "interfaces";
            }
            case ALL_CLASSES: {
                return "all-classes";
            }
            case CLASS_HIERARCHY: {
                return "class-hierarchy";
            }
        }
        throw new IllegalStateException("unkown " + autoExport);
    }

    private void writeInterfaces(XMLStreamWriter writer, Class<?>[] classes) throws XMLStreamException {
        writer.writeStartElement("interfaces");
        for (Class<?> singleClass : classes) {
            writer.writeStartElement("value");
            writer.writeCharacters(singleClass.getName());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

