/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.blueprint.service;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.annotation.service.ServiceProperty;

class ServicePropertyWriter {
    private final List<ServiceProperty> serviceProperties;

    ServicePropertyWriter(ServiceProperty[] serviceProperties, int ranking) {
        this.serviceProperties = this.filterProperties(serviceProperties, ranking != 0);
    }

    private List<ServiceProperty> filterProperties(ServiceProperty[] properties, boolean rankingAlreadyProvided) {
        ArrayList<ServiceProperty> filtered = new ArrayList<ServiceProperty>();
        for (ServiceProperty sp : properties) {
            if (rankingAlreadyProvided && sp.name().equals("service.ranking") || sp.values().length == 0) continue;
            filtered.add(sp);
        }
        return filtered;
    }

    void writeProperties(XMLStreamWriter writer) throws XMLStreamException {
        if (!this.serviceProperties.isEmpty()) {
            writer.writeStartElement("service-properties");
            for (ServiceProperty serviceProperty : this.serviceProperties) {
                this.writeServiceProperty(writer, serviceProperty);
            }
            writer.writeEndElement();
        }
    }

    private void writeServiceProperty(XMLStreamWriter writer, ServiceProperty serviceProperty) throws XMLStreamException {
        writer.writeStartElement("entry");
        writer.writeAttribute("key", serviceProperty.name());
        if (this.isSingleValue(serviceProperty)) {
            this.writeOneValueProperty(writer, serviceProperty);
        } else {
            this.writeMultiValueProperty(writer, serviceProperty);
        }
        writer.writeEndElement();
    }

    private boolean isSingleValue(ServiceProperty serviceProperty) {
        return serviceProperty.values().length == 1;
    }

    private boolean isStringProperty(ServiceProperty serviceProperty) {
        return serviceProperty.type().equals(String.class);
    }

    private void writeOneValueProperty(XMLStreamWriter writer, ServiceProperty serviceProperty) throws XMLStreamException {
        if (this.isStringProperty(serviceProperty)) {
            writer.writeAttribute("value", serviceProperty.values()[0]);
        } else {
            writer.writeStartElement("value");
            writer.writeAttribute("type", serviceProperty.type().getName());
            writer.writeCharacters(serviceProperty.values()[0]);
            writer.writeEndElement();
        }
    }

    private void writeMultiValueProperty(XMLStreamWriter writer, ServiceProperty serviceProperty) throws XMLStreamException {
        writer.writeStartElement("array");
        if (!this.isStringProperty(serviceProperty)) {
            writer.writeAttribute("value-type", serviceProperty.type().getName());
        }
        for (String value : serviceProperty.values()) {
            writer.writeStartElement("value");
            writer.writeCharacters(value);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

