/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.javax;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.handlers.javax.Namespaces;
import org.apache.aries.blueprint.plugin.spi.BeanAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.BeanEnricher;
import org.apache.aries.blueprint.plugin.spi.BlueprintConfiguration;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.MethodAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

abstract class AbstractTransactionFactory<T extends Annotation>
implements BeanAnnotationHandler<T>,
MethodAnnotationHandler<T> {
    private static final String ENABLE_ANNOTATION = "transaction.enableAnnotation";

    AbstractTransactionFactory() {
    }

    abstract String getTransactionTypeName(AnnotatedElement var1);

    public void handleMethodAnnotation(Class<?> clazz, List<Method> methods, ContextEnricher contextEnricher, BeanEnricher beanEnricher) {
        String nsTx2;
        final String nsTx1 = Namespaces.getNamespaceByPattern(contextEnricher.getBlueprintConfiguration().getNamespaces(), "http\\:\\/\\/aries\\.apache\\.org\\/xmlns\\/transactions\\/v1\\.(.)\\.(.)");
        if (nsTx1 != null) {
            this.enableAnnotationTx1(contextEnricher, nsTx1);
            for (Method method : methods) {
                final String transactionTypeName = this.getTransactionTypeName(method);
                final String name = method.getName();
                beanEnricher.addBeanContentWriter("javax.transactional.method/" + clazz.getName() + "/" + name + "/" + transactionTypeName, new XmlWriter(){

                    public void write(XMLStreamWriter writer) throws XMLStreamException {
                        writer.writeEmptyElement("transaction");
                        writer.writeDefaultNamespace(nsTx1);
                        writer.writeAttribute("method", name);
                        writer.writeAttribute("value", transactionTypeName);
                    }
                });
            }
        }
        if ((nsTx2 = Namespaces.getNamespaceByPattern(contextEnricher.getBlueprintConfiguration().getNamespaces(), "http\\:\\/\\/aries\\.apache\\.org\\/xmlns\\/transactions\\/v2\\.(.)\\.(.)")) != null) {
            this.insertEnableAnnotationTx2(contextEnricher, nsTx2);
        }
    }

    public void handleBeanAnnotation(AnnotatedElement annotatedElement, String id, ContextEnricher contextEnricher, BeanEnricher beanEnricher) {
        String nsTx2;
        final String nsTx1 = Namespaces.getNamespaceByPattern(contextEnricher.getBlueprintConfiguration().getNamespaces(), "http\\:\\/\\/aries\\.apache\\.org\\/xmlns\\/transactions\\/v1\\.(.)\\.(.)");
        if (nsTx1 != null) {
            this.enableAnnotationTx1(contextEnricher, nsTx1);
            final String transactionTypeName = this.getTransactionTypeName(annotatedElement);
            beanEnricher.addBeanContentWriter("javax.transactional.method/" + annotatedElement + "/*/" + transactionTypeName, new XmlWriter(){

                public void write(XMLStreamWriter writer) throws XMLStreamException {
                    writer.writeEmptyElement("transaction");
                    writer.writeDefaultNamespace(nsTx1);
                    writer.writeAttribute("method", "*");
                    writer.writeAttribute("value", transactionTypeName);
                }
            });
        }
        if ((nsTx2 = Namespaces.getNamespaceByPattern(contextEnricher.getBlueprintConfiguration().getNamespaces(), "http\\:\\/\\/aries\\.apache\\.org\\/xmlns\\/transactions\\/v2\\.(.)\\.(.)")) != null) {
            this.insertEnableAnnotationTx2(contextEnricher, nsTx2);
        }
    }

    private void enableAnnotationTx1(ContextEnricher contextEnricher, String nsTx1) {
        if (Namespaces.isTX12(nsTx1) && this.getEnableAnnotationConfig(contextEnricher.getBlueprintConfiguration())) {
            this.insertEnableAnnotationTx1(contextEnricher, nsTx1);
        }
    }

    private boolean getEnableAnnotationConfig(BlueprintConfiguration blueprintConfig) {
        String enableAnnotation = (String)blueprintConfig.getCustomParameters().get(ENABLE_ANNOTATION);
        return enableAnnotation == null || Boolean.parseBoolean(enableAnnotation);
    }

    private void insertEnableAnnotationTx1(ContextEnricher contextEnricher, final String namespace) {
        contextEnricher.addBlueprintContentWriter("transaction/ennable-annotation", new XmlWriter(){

            public void write(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeEmptyElement("enable-annotations");
                writer.writeDefaultNamespace(namespace);
            }
        });
    }

    private void insertEnableAnnotationTx2(ContextEnricher contextEnricher, final String namespace) {
        contextEnricher.addBlueprintContentWriter("transaction/ennable-annotation", new XmlWriter(){

            public void write(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeEmptyElement("enable");
                writer.writeDefaultNamespace(namespace);
            }
        });
    }
}

