/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.javax;

import java.lang.reflect.Field;
import java.util.List;
import javax.persistence.PersistenceUnit;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.handlers.javax.Namespaces;
import org.apache.aries.blueprint.plugin.spi.BeanEnricher;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.FieldAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

public class PersistenceUnitHandler
implements FieldAnnotationHandler<PersistenceUnit> {
    public Class<PersistenceUnit> getAnnotation() {
        return PersistenceUnit.class;
    }

    public void handleFieldAnnotation(Class<?> clazz, List<Field> fields, ContextEnricher contextEnricher, BeanEnricher beanEnricher) {
        String nsJpa2;
        final String nsJpa1 = Namespaces.getNamespaceByPattern(contextEnricher.getBlueprintConfiguration().getNamespaces(), "http\\:\\/\\/aries\\.apache\\.org\\/xmlns\\/jpa\\/v1\\.(.)\\.(.)");
        if (nsJpa1 != null) {
            for (Field field : fields) {
                final String name = field.getName();
                final PersistenceUnit persistenceUnit = field.getAnnotation(PersistenceUnit.class);
                beanEnricher.addBeanContentWriter("javax.persistence.field.unit/" + name, new XmlWriter(){

                    public void write(XMLStreamWriter writer) throws XMLStreamException {
                        writer.writeEmptyElement("unit");
                        writer.writeDefaultNamespace(nsJpa1);
                        writer.writeAttribute("unitname", persistenceUnit.unitName());
                        writer.writeAttribute("property", name);
                    }
                });
            }
        }
        if ((nsJpa2 = Namespaces.getNamespaceByPattern(contextEnricher.getBlueprintConfiguration().getNamespaces(), "http\\:\\/\\/aries\\.apache\\.org\\/xmlns\\/jpa\\/v2\\.(.)\\.(.)")) != null) {
            contextEnricher.addBlueprintContentWriter("javax.persistence.enableJpa2", new XmlWriter(){

                public void write(XMLStreamWriter writer) throws XMLStreamException {
                    writer.writeEmptyElement("enable");
                    writer.writeDefaultNamespace(nsJpa2);
                }
            });
        }
    }
}

