/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.apache.aries.blueprint.plugin.handlers.Handlers;
import org.apache.aries.blueprint.plugin.spi.CollectionDependencyAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.InjectLikeHandler;
import org.apache.aries.blueprint.plugin.spi.NamedLikeHandler;
import org.apache.aries.blueprint.plugin.spi.ValueInjectionHandler;

class AnnotationHelper {
    static Class<? extends Annotation>[] injectDependencyAnnotations = AnnotationHelper.findInjectDependencyAnnotations();

    AnnotationHelper() {
    }

    private static Class<? extends Annotation>[] findInjectDependencyAnnotations() {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (InjectLikeHandler<? extends Annotation> injectLikeHandler : Handlers.BEAN_INJECT_LIKE_HANDLERS) {
            classes.add(injectLikeHandler.getAnnotation());
        }
        for (ValueInjectionHandler valueInjectionHandler : Handlers.VALUE_INJECTION_HANDLERS) {
            classes.add(valueInjectionHandler.getAnnotation());
        }
        for (CollectionDependencyAnnotationHandler collectionDependencyAnnotationHandler : Handlers.COLLECTION_DEPENDENCY_ANNOTATION_HANDLERS) {
            classes.add(collectionDependencyAnnotationHandler.getAnnotation());
        }
        return classes.toArray(new Class[classes.size()]);
    }

    static String findValue(Annotation[] annotations) {
        for (ValueInjectionHandler<? extends Annotation> valueInjectionHandler : Handlers.VALUE_INJECTION_HANDLERS) {
            String value;
            Object annotation = AnnotationHelper.findAnnotation(annotations, valueInjectionHandler.getAnnotation());
            if (annotation == null || (value = valueInjectionHandler.getValue(annotation)) == null) continue;
            return value;
        }
        return null;
    }

    static String findName(Annotation[] annotations) {
        for (NamedLikeHandler namedLikeHandler : Handlers.NAMED_LIKE_HANDLERS) {
            String value;
            Object annotation = AnnotationHelper.findAnnotation(annotations, namedLikeHandler.getAnnotation());
            if (annotation == null || (value = namedLikeHandler.getName(annotation)) == null) continue;
            return value;
        }
        return null;
    }

    static <T> T findAnnotation(Annotation[] annotations, Class<T> annotation) {
        for (Annotation a : annotations) {
            if (a.annotationType() != annotation) continue;
            return annotation.cast(a);
        }
        return null;
    }

    static boolean findSingletons(Annotation[] annotations) {
        for (Class<? extends Annotation> singletonAnnotation : Handlers.SINGLETONS) {
            Annotation annotation = AnnotationHelper.findAnnotation(annotations, singletonAnnotation);
            if (annotation == null) continue;
            return true;
        }
        return false;
    }

    static boolean findSingleton(Class clazz) {
        for (Class<? extends Annotation> singletonAnnotation : Handlers.SINGLETONS) {
            if (clazz.getAnnotation(singletonAnnotation) == null) continue;
            return true;
        }
        return false;
    }
}

