/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.lang.annotation.Annotation;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.handlers.Handlers;
import org.apache.aries.blueprint.plugin.model.AnnotationHelper;
import org.apache.aries.blueprint.plugin.model.BeanRef;
import org.apache.aries.blueprint.plugin.model.BeanTemplate;
import org.apache.aries.blueprint.plugin.model.BlueprintRegistry;
import org.apache.aries.blueprint.plugin.model.NamingHelper;
import org.apache.aries.blueprint.plugin.model.RefCollection;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.CustomDependencyAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

class Argument
implements XmlWriter {
    private final String ref;
    private final String value;
    private final RefCollection refCollection;

    Argument(BlueprintRegistry blueprintRegistry, Class<?> argumentClass, Annotation[] annotations) {
        this.value = AnnotationHelper.findValue(annotations);
        if (this.value != null) {
            this.ref = null;
            this.refCollection = null;
            return;
        }
        this.refCollection = RefCollection.getRefCollection(blueprintRegistry, argumentClass, annotations);
        if (this.refCollection != null) {
            this.ref = null;
            return;
        }
        this.ref = this.findRef(blueprintRegistry, argumentClass, annotations);
    }

    private String findRef(BlueprintRegistry blueprintRegistry, Class<?> argumentClass, Annotation[] annotations) {
        String ref = AnnotationHelper.findName(annotations);
        for (CustomDependencyAnnotationHandler<? extends Annotation> customDependencyAnnotationHandler : Handlers.CUSTOM_DEPENDENCY_ANNOTATION_HANDLERS) {
            String generatedRef;
            Annotation annotation = (Annotation)AnnotationHelper.findAnnotation(annotations, customDependencyAnnotationHandler.getAnnotation());
            if (annotation == null || (generatedRef = customDependencyAnnotationHandler.handleDependencyAnnotation(argumentClass, annotation, ref, (ContextEnricher)blueprintRegistry)) == null) continue;
            ref = generatedRef;
            break;
        }
        if (ref == null) {
            BeanTemplate template = new BeanTemplate(argumentClass, annotations);
            BeanRef bean = blueprintRegistry.getMatching(template);
            ref = bean != null ? bean.id : NamingHelper.getBeanName(argumentClass);
        }
        return ref;
    }

    String getRef() {
        return this.ref;
    }

    String getValue() {
        return this.value;
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("argument");
        if (this.ref != null) {
            writer.writeAttribute("ref", this.ref);
        } else if (this.value != null) {
            writer.writeAttribute("value", this.value);
        } else if (this.refCollection != null) {
            this.refCollection.write(writer);
        }
        writer.writeEndElement();
    }
}

