/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.handlers.Handlers;
import org.apache.aries.blueprint.plugin.model.AnnotationHelper;
import org.apache.aries.blueprint.plugin.model.Argument;
import org.apache.aries.blueprint.plugin.model.BeanRef;
import org.apache.aries.blueprint.plugin.model.BlueprintRegistry;
import org.apache.aries.blueprint.plugin.model.Introspector;
import org.apache.aries.blueprint.plugin.model.NamingHelper;
import org.apache.aries.blueprint.plugin.model.Property;
import org.apache.aries.blueprint.plugin.spi.BeanAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.BeanEnricher;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.FieldAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.InjectLikeHandler;
import org.apache.aries.blueprint.plugin.spi.MethodAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

class Bean
implements BeanEnricher,
XmlWriter,
Comparable<Bean> {
    private static final String NS_EXT = "http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0";
    String id;
    final Class<?> clazz;
    SortedSet<Property> properties = new TreeSet<Property>();
    List<Argument> constructorArguments = new ArrayList<Argument>();
    final Map<String, String> attributes = new HashMap<String, String>();
    final Map<String, XmlWriter> beanContentWriters = new HashMap<String, XmlWriter>();
    protected final ContextEnricher contextEnricher;
    private final Introspector introspector;

    Bean(Class<?> clazz, ContextEnricher contextEnricher) {
        this.clazz = clazz;
        this.id = NamingHelper.getBeanName(clazz);
        this.contextEnricher = contextEnricher;
        this.introspector = new Introspector(clazz);
        this.setScope(clazz);
        this.handleCustomBeanAnnotations();
        this.handleFieldsAnnotation(this.introspector);
        this.handleMethodsAnnotation(this.introspector);
    }

    private void setScope(Class<?> clazz) {
        this.attributes.put("scope", AnnotationHelper.findSingleton(clazz) ? "singleton" : "prototype");
    }

    void resolveDependency(BlueprintRegistry blueprintRegistry) {
        this.resolveArguments(blueprintRegistry);
        this.resolveFields(blueprintRegistry);
        this.resolveMethods(blueprintRegistry);
    }

    private void handleMethodsAnnotation(Introspector introspector) {
        for (MethodAnnotationHandler<? extends Annotation> methodAnnotationHandler : Handlers.METHOD_ANNOTATION_HANDLERS) {
            List<Method> methods = introspector.methodsWith(methodAnnotationHandler.getAnnotation());
            if (methods.size() <= 0) continue;
            methodAnnotationHandler.handleMethodAnnotation(this.clazz, methods, this.contextEnricher, (BeanEnricher)this);
        }
    }

    private void handleFieldsAnnotation(Introspector introspector) {
        for (FieldAnnotationHandler<? extends Annotation> fieldAnnotationHandler : Handlers.FIELD_ANNOTATION_HANDLERS) {
            List<Field> fields = introspector.fieldsWith(fieldAnnotationHandler.getAnnotation());
            if (fields.size() <= 0) continue;
            fieldAnnotationHandler.handleFieldAnnotation(this.clazz, fields, this.contextEnricher, (BeanEnricher)this);
        }
    }

    private void handleCustomBeanAnnotations() {
        for (BeanAnnotationHandler<? extends Annotation> beanAnnotationHandler : Handlers.BEAN_ANNOTATION_HANDLERS) {
            Object annotation = AnnotationHelper.findAnnotation(this.clazz.getAnnotations(), beanAnnotationHandler.getAnnotation());
            if (annotation == null) continue;
            beanAnnotationHandler.handleBeanAnnotation(this.clazz, this.id, this.contextEnricher, (BeanEnricher)this);
        }
    }

    private void resolveMethods(BlueprintRegistry blueprintRegistry) {
        for (Method method : this.introspector.methodsWith(AnnotationHelper.injectDependencyAnnotations)) {
            Property prop = Property.create(blueprintRegistry, method);
            if (prop == null) continue;
            this.properties.add(prop);
        }
    }

    private void resolveFields(BlueprintRegistry matcher) {
        for (Field field : this.introspector.fieldsWith(AnnotationHelper.injectDependencyAnnotations)) {
            Property prop = Property.create(matcher, field);
            if (prop == null) continue;
            this.properties.add(prop);
        }
    }

    protected void resolveArguments(BlueprintRegistry matcher) {
        Constructor<?>[] declaredConstructors;
        for (Constructor<?> constructor : declaredConstructors = this.clazz.getDeclaredConstructors()) {
            if (declaredConstructors.length != 1 && !this.shouldInject(constructor)) continue;
            this.resolveArguments(matcher, constructor.getParameterTypes(), constructor.getParameterAnnotations());
            break;
        }
    }

    private boolean shouldInject(AnnotatedElement annotatedElement) {
        for (InjectLikeHandler<? extends Annotation> injectLikeHandler : Handlers.BEAN_INJECT_LIKE_HANDLERS) {
            if (annotatedElement.getAnnotation(injectLikeHandler.getAnnotation()) == null) continue;
            return true;
        }
        return false;
    }

    void resolveArguments(BlueprintRegistry blueprintRegistry, Class[] parameterTypes, Annotation[][] parameterAnnotations) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            this.constructorArguments.add(new Argument(blueprintRegistry, parameterTypes[i], parameterAnnotations[i]));
        }
    }

    private void writeProperties(XMLStreamWriter writer) throws XMLStreamException {
        for (Property property : this.properties) {
            property.write(writer);
        }
    }

    private void writeArguments(XMLStreamWriter writer) throws XMLStreamException {
        for (Argument argument : this.constructorArguments) {
            argument.write(writer);
        }
    }

    private boolean needFieldInjection() {
        for (Property property : this.properties) {
            if (!property.isField) continue;
            return true;
        }
        return false;
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void addBeanContentWriter(String id, XmlWriter blueprintWriter) {
        this.beanContentWriters.put(id, blueprintWriter);
    }

    private void writeCustomContent(XMLStreamWriter writer) throws XMLStreamException {
        ArrayList<String> customWriterKeys = new ArrayList<String>(this.beanContentWriters.keySet());
        Collections.sort(customWriterKeys);
        for (String customWriterKey : customWriterKeys) {
            this.beanContentWriters.get(customWriterKey).write(writer);
        }
    }

    private void writeAttributes(XMLStreamWriter writer) throws XMLStreamException {
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            if ("scope".equals(entry.getKey()) && "singleton".equals(entry.getValue())) continue;
            writer.writeAttribute(entry.getKey(), entry.getValue());
        }
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        this.writeBeanStart(writer);
        this.writeCustomContent(writer);
        this.writeArguments(writer);
        this.writeProperties(writer);
        writer.writeEndElement();
    }

    private void writeBeanStart(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("bean");
        writer.writeAttribute("id", this.id);
        writer.writeAttribute("class", this.clazz.getName());
        if (this.needFieldInjection()) {
            writer.writeNamespace("ext", NS_EXT);
            writer.writeAttribute("ext", NS_EXT, "field-injection", "true");
        }
        this.writeAttributes(writer);
    }

    BeanRef toBeanRef() {
        return new BeanRef(this.clazz, this.id, this.clazz.getAnnotations());
    }

    @Override
    public int compareTo(Bean o) {
        return this.id.compareTo(o.id);
    }
}

