/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.apache.aries.blueprint.plugin.handlers.Handlers;
import org.apache.aries.blueprint.plugin.model.AnnotationHelper;
import org.apache.aries.blueprint.plugin.model.Bean;
import org.apache.aries.blueprint.plugin.model.BeanRef;
import org.apache.aries.blueprint.plugin.model.BlueprintRegistry;
import org.apache.aries.blueprint.plugin.spi.BeanAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.BeanEnricher;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;

class BeanFromFactory
extends Bean {
    private static final String BLUEPRINT_BEAN_FROM_FACTORY_NAME_PROPERTY = "blueprint.beanFromFactory.nameFromFactoryMethodName";
    private final Method producingMethod;

    BeanFromFactory(Bean factoryBean, Method factoryMethod, ContextEnricher contextEnricher) {
        super(factoryMethod.getReturnType(), contextEnricher);
        String forcedId = AnnotationHelper.findName(factoryMethod.getAnnotations());
        if (forcedId != null) {
            this.id = forcedId;
        }
        if (forcedId == null && this.shouldGetBeanNameFromMethodName(contextEnricher)) {
            this.id = factoryMethod.getName();
        }
        this.producingMethod = factoryMethod;
        this.setScope(factoryMethod);
        this.handleCustomBeanAnnotations();
        this.attributes.put("factory-ref", factoryBean.id);
        this.attributes.put("factory-method", this.producingMethod.getName());
    }

    private boolean shouldGetBeanNameFromMethodName(ContextEnricher contextEnricher) {
        String value = (String)contextEnricher.getBlueprintConfiguration().getCustomParameters().get(BLUEPRINT_BEAN_FROM_FACTORY_NAME_PROPERTY);
        return Boolean.parseBoolean(value);
    }

    private void setScope(Method factoryMethod) {
        if (AnnotationHelper.findSingletons(factoryMethod.getAnnotations())) {
            this.attributes.put("scope", "singleton");
        }
    }

    private void handleCustomBeanAnnotations() {
        for (BeanAnnotationHandler<? extends Annotation> beanAnnotationHandler : Handlers.BEAN_ANNOTATION_HANDLERS) {
            Object annotation = AnnotationHelper.findAnnotation(this.producingMethod.getAnnotations(), beanAnnotationHandler.getAnnotation());
            if (annotation == null) continue;
            beanAnnotationHandler.handleBeanAnnotation((AnnotatedElement)this.producingMethod, this.id, this.contextEnricher, (BeanEnricher)this);
        }
    }

    @Override
    protected void resolveArguments(BlueprintRegistry matcher) {
        this.resolveArguments(matcher, this.producingMethod.getParameterTypes(), this.producingMethod.getParameterAnnotations());
    }

    @Override
    BeanRef toBeanRef() {
        return new BeanRef(this.clazz, this.id, this.producingMethod.getAnnotations());
    }
}

