/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.aries.blueprint.plugin.model.BeanTemplate;
import org.apache.aries.blueprint.plugin.model.QualifierHelper;

final class BeanRef
implements Comparable<BeanRef> {
    final String id;
    final Class<?> clazz;
    private final Set<Annotation> qualifiers;

    BeanRef(Class<?> clazz, String id, Annotation[] qualifiers) {
        this.clazz = clazz;
        this.id = id;
        this.qualifiers = QualifierHelper.getQualifiers(qualifiers);
    }

    boolean matches(BeanTemplate template) {
        boolean assignable = template.clazz.isAssignableFrom(this.clazz);
        return assignable && this.qualifiers.containsAll(template.qualifiers);
    }

    @Override
    public int compareTo(BeanRef other) {
        return this.id.compareTo(other.id);
    }

    boolean conflictsWith(BeanRef bean) {
        return this.id.equals(bean.id) && !this.clazz.equals(bean.clazz);
    }
}

