/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.aries.blueprint.plugin.model.BeanRef;
import org.apache.aries.blueprint.plugin.model.BeanTemplate;
import org.apache.aries.blueprint.plugin.model.ConflictDetected;

class BeanRefStore {
    private SortedSet<BeanRef> reg = new TreeSet<BeanRef>();

    BeanRefStore() {
    }

    void addBean(BeanRef beanRef) {
        this.rejectOnConflict(beanRef);
        this.reg.add(beanRef);
    }

    private void rejectOnConflict(BeanRef beanRef) {
        for (BeanRef bean : this.reg) {
            if (!beanRef.conflictsWith(bean)) continue;
            throw new ConflictDetected(beanRef, bean);
        }
    }

    BeanRef getMatching(BeanTemplate template) {
        for (BeanRef bean : this.reg) {
            if (!bean.matches(template)) continue;
            return bean;
        }
        return null;
    }

    List<BeanRef> getAllMatching(BeanTemplate template) {
        ArrayList<BeanRef> refs = new ArrayList<BeanRef>();
        for (BeanRef bean : this.reg) {
            if (!bean.matches(template)) continue;
            refs.add(bean);
        }
        return refs;
    }
}

