/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.handlers.Handlers;
import org.apache.aries.blueprint.plugin.model.AnnotationHelper;
import org.apache.aries.blueprint.plugin.model.Bean;
import org.apache.aries.blueprint.plugin.model.BeanFromFactory;
import org.apache.aries.blueprint.plugin.model.BeanRef;
import org.apache.aries.blueprint.plugin.model.BeanRefStore;
import org.apache.aries.blueprint.plugin.model.BeanTemplate;
import org.apache.aries.blueprint.plugin.model.BlueprintRegistry;
import org.apache.aries.blueprint.plugin.model.CustomTypeConverterWriter;
import org.apache.aries.blueprint.plugin.spi.BlueprintConfiguration;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.ContextInitializationHandler;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

public class Blueprint
implements BlueprintRegistry,
ContextEnricher,
XmlWriter {
    private static final String NS_BLUEPRINT = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    private final BeanRefStore beanRefStore = new BeanRefStore();
    private final Map<String, XmlWriter> customWriters = new HashMap<String, XmlWriter>();
    private final BlueprintConfiguration blueprintConfiguration;
    private final List<Bean> generatedBeans = new ArrayList<Bean>();

    Blueprint(BlueprintConfiguration blueprintConfiguration, Class<?> ... beanClasses) {
        this(blueprintConfiguration, Arrays.asList(beanClasses));
    }

    public Blueprint(BlueprintConfiguration blueprintConfiguration, Collection<Class<?>> beanClasses) {
        this.blueprintConfiguration = blueprintConfiguration;
        this.initContext();
        this.parseBeans(beanClasses);
        this.resolveDependency();
    }

    private void initContext() {
        for (ContextInitializationHandler contextInitializationHandler : Handlers.CONTEXT_INITIALIZATION_HANDLERS) {
            contextInitializationHandler.initContext((ContextEnricher)this);
        }
    }

    private void parseBeans(Collection<Class<?>> beanClasses) {
        for (Class<?> clazz : beanClasses) {
            this.parseBean(clazz);
        }
    }

    private void parseBean(Class<?> clazz) {
        Bean bean = new Bean(clazz, this);
        this.beanRefStore.addBean(bean.toBeanRef());
        this.generatedBeans.add(bean);
        this.addBeansFromFactories(bean);
    }

    private void addBeansFromFactories(Bean factoryBean) {
        for (Method method : factoryBean.clazz.getMethods()) {
            if (!this.isFactoryMethod(method)) continue;
            BeanFromFactory beanFromFactory = new BeanFromFactory(factoryBean, method, this);
            this.beanRefStore.addBean(beanFromFactory.toBeanRef());
            this.generatedBeans.add(beanFromFactory);
        }
    }

    private boolean isFactoryMethod(Method method) {
        boolean isFactoryMethod = false;
        for (Class<? extends Annotation> factoryMethodAnnotationClass : Handlers.FACTORY_METHOD_ANNOTATION_CLASSES) {
            Annotation annotation = AnnotationHelper.findAnnotation(method.getAnnotations(), factoryMethodAnnotationClass);
            if (annotation == null) continue;
            isFactoryMethod = true;
            break;
        }
        return isFactoryMethod;
    }

    private void resolveDependency() {
        for (Bean bean : this.generatedBeans) {
            bean.resolveDependency(this);
        }
    }

    @Override
    public BeanRef getMatching(BeanTemplate template) {
        return this.beanRefStore.getMatching(template);
    }

    @Override
    public List<BeanRef> getAllMatching(BeanTemplate template) {
        return this.beanRefStore.getAllMatching(template);
    }

    Collection<Bean> getBeans() {
        return this.generatedBeans;
    }

    Map<String, XmlWriter> getCustomWriters() {
        return this.customWriters;
    }

    public void addBean(String id, Class<?> clazz) {
        this.beanRefStore.addBean(new BeanRef(clazz, id, new Annotation[0]));
    }

    public void addBlueprintContentWriter(String id, XmlWriter blueprintWriter) {
        this.customWriters.put(id, blueprintWriter);
    }

    public BlueprintConfiguration getBlueprintConfiguration() {
        return this.blueprintConfiguration;
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        this.writeBlueprint(writer);
        this.writeTypeConverters(writer);
        this.writeBeans(writer);
        this.writeCustomWriters(writer);
        writer.writeEndElement();
    }

    private void writeTypeConverters(XMLStreamWriter writer) throws XMLStreamException {
        new CustomTypeConverterWriter(this.beanRefStore).write(writer);
    }

    private void writeCustomWriters(XMLStreamWriter writer) throws XMLStreamException {
        ArrayList<String> customWriterKeys = new ArrayList<String>(this.customWriters.keySet());
        Collections.sort(customWriterKeys);
        for (String customWriterKey : customWriterKeys) {
            this.customWriters.get(customWriterKey).write(writer);
        }
    }

    private void writeBeans(XMLStreamWriter writer) throws XMLStreamException {
        Collections.sort(this.generatedBeans);
        for (Bean beanWriter : this.generatedBeans) {
            beanWriter.write(writer);
        }
    }

    private void writeBlueprint(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("blueprint");
        writer.writeDefaultNamespace(NS_BLUEPRINT);
        if (this.blueprintConfiguration.getDefaultActivation() != null) {
            writer.writeAttribute("default-activation", this.blueprintConfiguration.getDefaultActivation().toString());
        }
        if (this.blueprintConfiguration.getDefaultAvailability() != null) {
            writer.writeAttribute("default-availability", this.blueprintConfiguration.getDefaultAvailability().toString());
        }
        if (this.blueprintConfiguration.getDefaultTimeout() != null) {
            writer.writeAttribute("default-timeout", this.blueprintConfiguration.getDefaultTimeout().toString());
        }
    }

    public boolean shouldBeGenerated() {
        return !this.getBeans().isEmpty();
    }
}

