/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.model.BeanRef;
import org.apache.aries.blueprint.plugin.model.BeanRefStore;
import org.apache.aries.blueprint.plugin.model.BeanTemplate;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;
import org.osgi.service.blueprint.container.Converter;

class CustomTypeConverterWriter
implements XmlWriter {
    private static final String defaultBlueprintConverter = "blueprintConverter";
    private final BeanRefStore beanRefStore;

    CustomTypeConverterWriter(BeanRefStore beanRefStore) {
        this.beanRefStore = beanRefStore;
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        List<BeanRef> typeConverters = this.beanRefStore.getAllMatching(new BeanTemplate(Converter.class, new Annotation[0]));
        if (this.hasCustomTypeConverters(typeConverters)) {
            return;
        }
        writer.writeStartElement("type-converters");
        for (BeanRef typeConverter : typeConverters) {
            if (defaultBlueprintConverter.equals(typeConverter.id)) continue;
            writer.writeEmptyElement("ref");
            writer.writeAttribute("component-id", typeConverter.id);
        }
        writer.writeEndElement();
    }

    private boolean hasCustomTypeConverters(List<BeanRef> typeConverters) {
        return typeConverters.isEmpty() || typeConverters.size() == 1 && defaultBlueprintConverter.equals(typeConverters.get((int)0).id);
    }
}

