/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

final class Introspector {
    private final Class<?> originalClazz;

    Introspector(Class<?> clazz) {
        this.originalClazz = clazz;
    }

    @SafeVarargs
    final List<Field> fieldsWith(Class<? extends Annotation> ... requiredAnnotations) {
        HashMultimap fieldsByName = HashMultimap.create();
        HashSet acceptedFieldNames = Sets.newHashSet();
        for (Class<?> clazz = this.originalClazz; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                fieldsByName.put((Object)field.getName(), (Object)field);
                if (!this.hasAnyRequiredAnnotation(field, requiredAnnotations)) continue;
                acceptedFieldNames.add(field.getName());
            }
        }
        ArrayList acceptedFields = Lists.newArrayList();
        for (String fieldName : acceptedFieldNames) {
            Collection fields = fieldsByName.get((Object)fieldName);
            this.validateOnlyOneFieldWithName(fieldName, fields);
            acceptedFields.addAll(fields);
        }
        return acceptedFields;
    }

    private void validateOnlyOneFieldWithName(String acceptedFieldName, Collection<Field> acceptedFieldsWithSameName) {
        if (acceptedFieldsWithSameName.size() > 1) {
            String header = String.format("Field '%s' in bean class '%s' has been defined multiple times in:", acceptedFieldName, this.originalClazz.getName());
            StringBuilder msgBuilder = new StringBuilder(header);
            for (Field field : acceptedFieldsWithSameName) {
                msgBuilder.append("\n\t- ").append(field.getDeclaringClass().getName());
            }
            throw new UnsupportedOperationException(msgBuilder.toString());
        }
    }

    @SafeVarargs
    private final boolean hasAnyRequiredAnnotation(Field field, Class<? extends Annotation> ... requiredAnnotations) {
        if (requiredAnnotations.length == 0) {
            throw new IllegalArgumentException("Must specify at least one annotation");
        }
        for (Class<? extends Annotation> requiredAnnotation : requiredAnnotations) {
            if (field.getAnnotation(requiredAnnotation) == null) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    final List<Method> methodsWith(Class<? extends Annotation> ... annotationClasses) {
        ArrayList<Method> methods = new ArrayList<Method>();
        block0: for (Method method : this.originalClazz.getMethods()) {
            for (Class<? extends Annotation> annotationClass : annotationClasses) {
                if (method.getAnnotation(annotationClass) == null) continue;
                methods.add(method);
                continue block0;
            }
        }
        return methods;
    }
}

