/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.handlers.Handlers;
import org.apache.aries.blueprint.plugin.model.AnnotationHelper;
import org.apache.aries.blueprint.plugin.model.BeanRef;
import org.apache.aries.blueprint.plugin.model.BeanTemplate;
import org.apache.aries.blueprint.plugin.model.BlueprintRegistry;
import org.apache.aries.blueprint.plugin.model.NamingHelper;
import org.apache.aries.blueprint.plugin.model.RefCollection;
import org.apache.aries.blueprint.plugin.spi.ContextEnricher;
import org.apache.aries.blueprint.plugin.spi.CustomDependencyAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.NamedLikeHandler;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

class Property
implements Comparable<Property>,
XmlWriter {
    public final String name;
    public final String ref;
    public final String value;
    final boolean isField;
    private final RefCollection refCollection;

    private Property(String name, String ref, String value, boolean isField, RefCollection refCollection) {
        this.name = name;
        this.ref = ref;
        this.value = value;
        this.isField = isField;
        this.refCollection = refCollection;
    }

    static Property create(BlueprintRegistry blueprintRegistry, Field field) {
        if (Property.needsInject(field)) {
            String value = AnnotationHelper.findValue(field.getAnnotations());
            if (value != null) {
                return new Property(field.getName(), null, value, true, null);
            }
            RefCollection refCollection = RefCollection.getRefCollection(blueprintRegistry, field);
            if (refCollection != null) {
                return new Property(field.getName(), null, null, true, refCollection);
            }
            String ref = Property.getForcedRefName(field);
            String refFromCustomeDependencyHandler = Property.getRefFromCustomDependencyHandlers(blueprintRegistry, field, ref);
            if (refFromCustomeDependencyHandler != null) {
                ref = refFromCustomeDependencyHandler;
            }
            if (ref != null) {
                return new Property(field.getName(), ref, null, true, null);
            }
            BeanRef matching = blueprintRegistry.getMatching(new BeanTemplate(field));
            ref = matching == null ? Property.getDefaultRefName(field) : matching.id;
            return new Property(field.getName(), ref, null, true, null);
        }
        return null;
    }

    private static String getRefFromCustomDependencyHandlers(BlueprintRegistry blueprintRegistry, AnnotatedElement annotatedElement, String ref) {
        for (CustomDependencyAnnotationHandler<? extends Annotation> customDependencyAnnotationHandler : Handlers.CUSTOM_DEPENDENCY_ANNOTATION_HANDLERS) {
            String generatedRef;
            Annotation annotation = (Annotation)AnnotationHelper.findAnnotation(annotatedElement.getAnnotations(), customDependencyAnnotationHandler.getAnnotation());
            if (annotation == null || (generatedRef = customDependencyAnnotationHandler.handleDependencyAnnotation(annotatedElement, ref, (ContextEnricher)blueprintRegistry)) == null) continue;
            return generatedRef;
        }
        return null;
    }

    static Property create(BlueprintRegistry blueprintRegistry, Method method) {
        String propertyName = Property.resolveProperty(method);
        if (propertyName == null) {
            return null;
        }
        String value = AnnotationHelper.findValue(method.getAnnotations());
        if (value != null) {
            return new Property(propertyName, null, value, false, null);
        }
        if (Property.needsInject(method)) {
            String refFromCustomeDependencyHandler;
            RefCollection refCollection = RefCollection.getRefCollection(blueprintRegistry, method);
            if (refCollection != null) {
                return new Property(propertyName, null, null, true, refCollection);
            }
            String ref = Property.getForcedRefName(method);
            if (ref == null) {
                ref = AnnotationHelper.findName(method.getParameterAnnotations()[0]);
            }
            if ((refFromCustomeDependencyHandler = Property.getRefFromCustomDependencyHandlers(blueprintRegistry, method, ref)) != null) {
                ref = refFromCustomeDependencyHandler;
            }
            if (ref != null) {
                return new Property(propertyName, ref, null, false, null);
            }
            for (CustomDependencyAnnotationHandler<? extends Annotation> customDependencyAnnotationHandler : Handlers.CUSTOM_DEPENDENCY_ANNOTATION_HANDLERS) {
                String generatedRef;
                Annotation annotation = (Annotation)AnnotationHelper.findAnnotation(method.getParameterAnnotations()[0], customDependencyAnnotationHandler.getAnnotation());
                if (annotation == null || (generatedRef = customDependencyAnnotationHandler.handleDependencyAnnotation(method.getParameterTypes()[0], annotation, ref, (ContextEnricher)blueprintRegistry)) == null) continue;
                ref = generatedRef;
                break;
            }
            if (ref != null) {
                return new Property(propertyName, ref, null, false, null);
            }
            BeanTemplate template = new BeanTemplate(method);
            BeanRef matching = blueprintRegistry.getMatching(template);
            ref = matching == null ? NamingHelper.getBeanName(method.getParameterTypes()[0]) : matching.id;
            return new Property(propertyName, ref, null, false, null);
        }
        return null;
    }

    private static String resolveProperty(Method method) {
        if (method.getParameterTypes().length != 1) {
            return null;
        }
        String propertyName = method.getName().substring(3);
        return Property.makeFirstLetterLower(propertyName);
    }

    private static String getDefaultRefName(Field field) {
        return NamingHelper.getBeanName(field.getType());
    }

    private static String getForcedRefName(Field field) {
        return Property.getForcedRefName(field.getType(), field);
    }

    private static String getForcedRefName(Method method) {
        return Property.getForcedRefName(method.getParameterTypes()[0], method);
    }

    private static String getForcedRefName(Class<?> clazz, AnnotatedElement annotatedElement) {
        for (NamedLikeHandler namedLikeHandler : Handlers.NAMED_LIKE_HANDLERS) {
            String name;
            if (annotatedElement.getAnnotation(namedLikeHandler.getAnnotation()) == null || (name = namedLikeHandler.getName(clazz, annotatedElement)) == null) continue;
            return name;
        }
        return null;
    }

    private static boolean needsInject(AnnotatedElement annotatedElement) {
        for (Class<? extends Annotation> injectDependencyAnnotation : AnnotationHelper.injectDependencyAnnotations) {
            if (annotatedElement.getAnnotation(injectDependencyAnnotation) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Property other) {
        return this.name.compareTo(other.name);
    }

    private static String makeFirstLetterLower(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1, name.length());
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("property");
        writer.writeAttribute("name", this.name);
        if (this.ref != null) {
            writer.writeAttribute("ref", this.ref);
        } else if (this.value != null) {
            writer.writeAttribute("value", this.value);
        } else if (this.refCollection != null) {
            this.refCollection.write(writer);
        }
        writer.writeEndElement();
    }
}

