/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.handlers.Handlers;
import org.apache.aries.blueprint.plugin.model.AnnotationHelper;
import org.apache.aries.blueprint.plugin.model.BeanRef;
import org.apache.aries.blueprint.plugin.model.BeanTemplate;
import org.apache.aries.blueprint.plugin.model.BlueprintRegistry;
import org.apache.aries.blueprint.plugin.spi.CollectionDependencyAnnotationHandler;
import org.apache.aries.blueprint.plugin.spi.XmlWriter;

class RefCollection
implements XmlWriter {
    private final String type;
    private final List<String> refs;

    private RefCollection(String type, List<String> refs) {
        this.type = type;
        this.refs = refs;
    }

    static RefCollection getRefCollection(BlueprintRegistry blueprintRegistry, Class<?> injectedType, Annotation[] annotations) {
        List<String> refCollection = RefCollection.getMatchingRefs(blueprintRegistry, annotations);
        if (refCollection == null) {
            return null;
        }
        String collectionType = RefCollection.recognizeCollectionType(injectedType);
        return new RefCollection(collectionType, refCollection);
    }

    static RefCollection getRefCollection(BlueprintRegistry blueprintRegistry, Field field) {
        return RefCollection.getRefCollection(blueprintRegistry, field.getType(), field.getAnnotations());
    }

    static RefCollection getRefCollection(BlueprintRegistry blueprintRegistry, Method method) {
        return RefCollection.getRefCollection(blueprintRegistry, method.getParameterTypes()[0], method.getAnnotations());
    }

    private static String recognizeCollectionType(Class<?> type) {
        if (type.isAssignableFrom(List.class)) {
            return "list";
        }
        if (type.isAssignableFrom(Set.class)) {
            return "set";
        }
        if (type.isArray()) {
            return "array";
        }
        throw new IllegalStateException("Expecting that class " + type.getName() + " will be Set, List or Array");
    }

    private static List<String> getMatchingRefs(BlueprintRegistry blueprintRegistry, Annotation[] annotations) {
        for (CollectionDependencyAnnotationHandler<? extends Annotation> collectionDependencyAnnotationHandler : Handlers.COLLECTION_DEPENDENCY_ANNOTATION_HANDLERS) {
            Annotation annotation = (Annotation)AnnotationHelper.findAnnotation(annotations, collectionDependencyAnnotationHandler.getAnnotation());
            if (annotation == null) continue;
            Class classCollection = collectionDependencyAnnotationHandler.getBeanClass(annotation);
            List<BeanRef> refs = blueprintRegistry.getAllMatching(new BeanTemplate(classCollection, annotations));
            ArrayList<String> refList = new ArrayList<String>();
            for (BeanRef ref : refs) {
                refList.add(ref.id);
            }
            return refList;
        }
        return null;
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(this.type);
        for (String componentId : this.refs) {
            writer.writeEmptyElement("ref");
            writer.writeAttribute("component-id", componentId);
        }
        writer.writeEndElement();
    }
}

