/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.tracker;

import org.apache.aries.util.tracker.InternalRecursiveBundleTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public final class RecursiveBundleTracker {
    private static final int COMPOSITE_BUNDLE_MASK = 58;
    private final BundleTracker tracker;

    public RecursiveBundleTracker(BundleContext context, int stateMask, BundleTrackerCustomizer customizer) {
        if ((stateMask & 0x3A) != 58) {
            throw new IllegalArgumentException();
        }
        this.tracker = RecursiveBundleTracker.areMultipleFrameworksAvailable(context) ? new InternalRecursiveBundleTracker(context, stateMask, customizer) : new BundleTracker(context, stateMask, customizer);
    }

    private static boolean areMultipleFrameworksAvailable(BundleContext context) {
        ServiceReference sr = context.getServiceReference("org.osgi.service.framework.CompositeBundleFactory");
        return sr != null;
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }
}

