/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util;

import org.apache.aries.util.internal.DefaultWorker;
import org.apache.aries.util.internal.EquinoxWorker;
import org.apache.aries.util.internal.FelixWorker;
import org.apache.aries.util.internal.FrameworkUtilWorker;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class AriesFrameworkUtil {
    private static FrameworkUtilWorker worker;

    public static ClassLoader getClassLoader(Bundle b) {
        if (b.getState() != 1 && b.getState() != 2) {
            return worker.getClassLoader(b);
        }
        return null;
    }

    private static boolean isEquinox(String bundleClassName) {
        if (bundleClassName.startsWith("org.eclipse.equinox")) {
            try {
                Class.forName("org.eclipse.osgi.framework.internal.core.BundleHost");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public static ClassLoader getClassLoaderForced(Bundle b) {
        try {
            b.loadClass("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return worker.getClassLoader(b);
    }

    static {
        Bundle b = FrameworkUtil.getBundle(AriesFrameworkUtil.class);
        String bundleClassName = b.getClass().getName();
        if (AriesFrameworkUtil.isEquinox(bundleClassName)) {
            worker = new EquinoxWorker();
        } else if (bundleClassName.startsWith("org.apache.felix")) {
            worker = new FelixWorker();
        }
        if (worker == null || !worker.isValid()) {
            worker = new DefaultWorker();
        }
    }
}

