/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.bulkimport;

import java.util.ArrayList;
import java.util.List;

public class BulkImportResponse {
    private List<ImportInfo> failedImportInfoList = new ArrayList<ImportInfo>();
    private List<ImportInfo> successImportInfoList = new ArrayList<ImportInfo>();

    public List<ImportInfo> getFailedImportInfoList() {
        return this.failedImportInfoList;
    }

    public void setFailedImportInfoList(List<ImportInfo> failedImportInfoList) {
        this.failedImportInfoList = failedImportInfoList;
    }

    public void setFailedImportInfoList(ImportInfo importInfo) {
        List<ImportInfo> failedImportInfoList = this.failedImportInfoList;
        if (failedImportInfoList == null) {
            failedImportInfoList = new ArrayList<ImportInfo>();
        }
        failedImportInfoList.add(importInfo);
        this.setFailedImportInfoList(failedImportInfoList);
    }

    public List<ImportInfo> getSuccessImportInfoList() {
        return this.successImportInfoList;
    }

    public void setSuccessImportInfoList(List<ImportInfo> successImportInfoList) {
        this.successImportInfoList = successImportInfoList;
    }

    public void setSuccessImportInfoList(ImportInfo importInfo) {
        List<ImportInfo> successImportInfoList = this.successImportInfoList;
        if (successImportInfoList == null) {
            successImportInfoList = new ArrayList<ImportInfo>();
        }
        successImportInfoList.add(importInfo);
        this.setSuccessImportInfoList(successImportInfoList);
    }

    public String toString() {
        return "BulkImportResponse{failedImportInfoList=" + this.failedImportInfoList + ", successImportInfoList=" + this.successImportInfoList + '}';
    }

    public static class ImportInfo {
        private String parentObjectName;
        private String childObjectName;
        private ImportStatus importStatus;
        private String remarks;
        private Integer rowNumber;

        public ImportInfo(String parentObjectName, String childObjectName, ImportStatus importStatus, String remarks, Integer rowNumber) {
            this.parentObjectName = parentObjectName;
            this.childObjectName = childObjectName;
            this.importStatus = importStatus;
            this.remarks = remarks;
            this.rowNumber = rowNumber;
        }

        public ImportInfo(String parentObjectName, String childObjectName, ImportStatus importStatus) {
            this(parentObjectName, childObjectName, importStatus, "", -1);
        }

        public ImportInfo(ImportStatus importStatus, String remarks) {
            this("", "", importStatus, remarks, -1);
        }

        public ImportInfo(ImportStatus importStatus, String remarks, Integer rowNumber) {
            this("", "", importStatus, remarks, rowNumber);
        }

        public ImportInfo(String parentObjectName, String childObjectName) {
            this(parentObjectName, childObjectName, ImportStatus.SUCCESS, "", -1);
        }

        public ImportInfo(String parentObjectName, String childObjectName, ImportStatus importStatus, String remarks) {
            this(parentObjectName, childObjectName, importStatus, remarks, -1);
        }

        public String getParentObjectName() {
            return this.parentObjectName;
        }

        public void setParentObjectName(String parentObjectName) {
            this.parentObjectName = parentObjectName;
        }

        public String getChildObjectName() {
            return this.childObjectName;
        }

        public void setChildObjectName(String childObjectName) {
            this.childObjectName = childObjectName;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public void setRemarks(String remarks) {
            this.remarks = remarks;
        }

        public ImportStatus getImportStatus() {
            return this.importStatus;
        }

        public void setImportStatus(ImportStatus importStatus) {
            this.importStatus = importStatus;
        }

        public String toString() {
            return "ImportInfo{parentObjectName='" + this.parentObjectName + '\'' + ", childObjectName='" + this.childObjectName + '\'' + ", remarks='" + this.remarks + '\'' + ", importStatus=" + (Object)((Object)this.importStatus) + ", rowNumber=" + this.rowNumber + '}';
        }
    }

    public static enum ImportStatus {
        SUCCESS,
        FAILED;

    }
}

