/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.v1.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.v1.model.instance.Id;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.commons.collections.MapUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class Struct
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_CLASS_STRUCT = "org.apache.atlas.typesystem.json.InstanceSerialization$_Struct";
    private String typeName;
    private Map<String, Object> values;

    public Struct() {
    }

    public Struct(Struct that) {
        if (that != null) {
            this.typeName = that.typeName;
            if (that.values != null) {
                this.values = new HashMap<String, Object>(that.values);
            }
        }
    }

    public Struct(String typeName) {
        this(typeName, null);
    }

    public Struct(String typeName, Map<String, Object> values) {
        this.typeName = typeName;
        this.values = values;
    }

    public Struct(Map<String, Object> map) {
        this();
        if (map != null) {
            this.typeName = Id.asString(map.get("typeName"));
            this.values = Id.asMap(map.get("values"));
            this.normalize();
        }
    }

    public String getJsonClass() {
        return JSON_CLASS_STRUCT;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void setValues(Map<String, Object> values) {
        this.values = values;
    }

    @JsonIgnore
    public Map<String, Object> getValuesMap() {
        return this.values;
    }

    @JsonIgnore
    public void set(String attrName, Object attrValue) {
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        this.values.put(attrName, attrValue);
    }

    @JsonIgnore
    public Object get(String attrName) {
        return this.values != null ? this.values.get(attrName) : null;
    }

    public void normalize() {
        if (MapUtils.isEmpty(this.values)) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            entry.setValue(this.normalizeAttributeValue(entry.getValue()));
        }
    }

    private Object normalizeAttributeValue(Object value) {
        if (value instanceof Map) {
            Map mapValue = (Map)((Object)value);
            String jsonClass = (String)mapValue.get("jsonClass");
            if (jsonClass != null) {
                if ("org.apache.atlas.typesystem.json.InstanceSerialization$_Id".equals(jsonClass)) {
                    value = new Id(mapValue);
                } else if (JSON_CLASS_STRUCT.equals(jsonClass)) {
                    value = new Struct(mapValue);
                } else if ("org.apache.atlas.typesystem.json.InstanceSerialization$_Reference".equals(jsonClass)) {
                    value = new Referenceable(mapValue);
                }
            }
        } else if (value instanceof List) {
            List listValue = value;
            ArrayList<Object> normalizedValue = new ArrayList<Object>(listValue.size());
            for (Object val : listValue) {
                normalizedValue.add(this.normalizeAttributeValue(val));
            }
            value = normalizedValue;
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Struct obj = (Struct)o;
        return Objects.equals(this.typeName, obj.typeName) && Objects.equals(this.values, obj.values);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.values);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Struct{");
        sb.append("typeName=").append(this.typeName);
        sb.append(", values={");
        AtlasBaseTypeDef.dumpObjects(this.values, sb);
        sb.append("}");
        sb.append("}");
        return sb;
    }
}

