/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.v1.model.typedef;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(using=MultiplicitySerializer.class, include=JsonSerialize.Inclusion.NON_NULL)
@JsonDeserialize(using=MultiplicityDeserializer.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class Multiplicity
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Multiplicity OPTIONAL = new Multiplicity(0, 1, false);
    public static final Multiplicity REQUIRED = new Multiplicity(1, 1, false);
    public static final Multiplicity COLLECTION = new Multiplicity(1, Integer.MAX_VALUE, false);
    public static final Multiplicity SET = new Multiplicity(1, Integer.MAX_VALUE, true);
    private int lower;
    private int upper;
    private boolean isUnique;

    public Multiplicity() {
        this(REQUIRED);
    }

    public Multiplicity(Multiplicity copyFrom) {
        this(copyFrom.lower, copyFrom.upper, copyFrom.isUnique);
    }

    public Multiplicity(int lower, int upper, boolean isUnique) {
        this.lower = lower;
        this.upper = upper;
        this.isUnique = isUnique;
    }

    public int getLower() {
        return this.lower;
    }

    public void setLower(int lower) {
        this.lower = lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public void setUpper(int upper) {
        this.upper = upper;
    }

    public boolean getIsUnique() {
        return this.isUnique;
    }

    public void setIsUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Multiplicity that = (Multiplicity)o;
        return this.lower == that.lower && this.upper == that.upper && this.isUnique == that.isUnique;
    }

    public int hashCode() {
        return Objects.hash(this.lower, this.upper, this.isUnique);
    }

    static class MultiplicityDeserializer
    extends JsonDeserializer<Multiplicity> {
        MultiplicityDeserializer() {
        }

        public Multiplicity deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Multiplicity ret = null;
            String value = (String)parser.readValueAs(String.class);
            if (value != null) {
                if (value.equals("required")) {
                    ret = new Multiplicity(REQUIRED);
                } else if (value.equals("optional")) {
                    ret = new Multiplicity(OPTIONAL);
                } else if (value.equals("collection")) {
                    ret = new Multiplicity(COLLECTION);
                } else if (value.equals("set")) {
                    ret = new Multiplicity(SET);
                }
            }
            if (ret == null) {
                ret = new Multiplicity();
            }
            return ret;
        }
    }

    static class MultiplicitySerializer
    extends JsonSerializer<Multiplicity> {
        MultiplicitySerializer() {
        }

        public void serialize(Multiplicity value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value != null) {
                String serializedValue = value.getLower() < 1 ? "optional" : (value.equals(COLLECTION) ? "collection" : (value.equals(SET) ? "set" : (value.equals(REQUIRED) ? "required" : "required")));
                jgen.writeString(serializedValue);
            }
        }
    }
}

