/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.profile;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import org.apache.atlas.model.AtlasBaseModelObject;
import org.apache.atlas.model.discovery.SearchParameters;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlasUserSavedSearch
extends AtlasBaseModelObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String ownerName;
    private String name;
    private SavedSearchType searchType;
    private SearchParameters searchParameters;
    private String uiParameters;

    public AtlasUserSavedSearch() {
        this(null, null, SavedSearchType.BASIC, null);
    }

    public AtlasUserSavedSearch(String name, SavedSearchType searchType, SearchParameters searchParameters) {
        this(null, name, searchType, searchParameters);
    }

    public AtlasUserSavedSearch(String ownerName, String name) {
        this(ownerName, name, SavedSearchType.BASIC, null);
    }

    public AtlasUserSavedSearch(String ownerName, String name, SavedSearchType savedSearchType, SearchParameters searchParameters) {
        this.setOwnerName(ownerName);
        this.setName(name);
        this.setSearchType(savedSearchType);
        this.setSearchParameters(searchParameters);
    }

    public AtlasUserSavedSearch(String ownerName, String name, SavedSearchType searchType, SearchParameters searchParameters, String uiParameters) {
        this(ownerName, name, searchType, searchParameters);
        this.setUiParameters(uiParameters);
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SavedSearchType getSearchType() {
        return this.searchType;
    }

    public void setSearchType(SavedSearchType searchType) {
        this.searchType = searchType;
    }

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    public void setSearchParameters(SearchParameters searchParameters) {
        this.searchParameters = searchParameters;
    }

    public String getUiParameters() {
        return this.uiParameters;
    }

    public void setUiParameters(String uiParameters) {
        this.uiParameters = uiParameters;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append(", ownerName=").append(this.ownerName);
        sb.append(", name=").append(this.name);
        sb.append(", searchType=").append((Object)this.searchType);
        sb.append(", searchParameters=");
        if (this.searchParameters == null) {
            sb.append("null");
        } else {
            this.searchParameters.toString(sb);
        }
        sb.append(", uiParameters=").append(this.uiParameters);
        return sb;
    }

    public static enum SavedSearchType {
        BASIC,
        ADVANCED,
        BASIC_RELATIONSHIP;


        public static SavedSearchType to(String val) {
            SavedSearchType searchType = BASIC;
            if (ADVANCED.name().equalsIgnoreCase(val)) {
                searchType = ADVANCED;
            } else if (BASIC_RELATIONSHIP.name().equalsIgnoreCase(val)) {
                searchType = BASIC_RELATIONSHIP;
            }
            return searchType;
        }
    }
}

