/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.hadoop.io.AvroKeyDeserializer;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.mapred.AvroWrapper;
import org.junit.Assert;
import org.junit.Test;

public class TestAvroKeyDeserializer {
    @Test
    public void testDeserialize() throws IOException {
        Schema writerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema readerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        ClassLoader classLoader = this.getClass().getClassLoader();
        AvroKeyDeserializer deserializer = new AvroKeyDeserializer(writerSchema, readerSchema, classLoader);
        Assert.assertEquals((Object)writerSchema, (Object)deserializer.getWriterSchema());
        Assert.assertEquals((Object)readerSchema, (Object)deserializer.getReaderSchema());
        GenericDatumWriter datumWriter = new GenericDatumWriter(writerSchema);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)outputStream, null);
        datumWriter.write((Object)"record1", (Encoder)encoder);
        datumWriter.write((Object)"record2", (Encoder)encoder);
        encoder.flush();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        deserializer.open((InputStream)inputStream);
        AvroWrapper record = null;
        record = deserializer.deserialize(record);
        Assert.assertEquals((Object)"record1", (Object)((CharSequence)record.datum()).toString());
        record = deserializer.deserialize(record);
        Assert.assertEquals((Object)"record2", (Object)((CharSequence)record.datum()).toString());
        deserializer.close();
    }
}

