/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.AvroTextOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestAvroTextOutputFormat {
    private static final String UTF8 = "UTF-8";

    @Test
    public void testAvroTextRecordWriter() throws Exception {
        File file = new File(System.getProperty("test.dir", "."), "writer");
        Schema schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter fileWriter = new DataFileWriter((DatumWriter)datumWriter);
        fileWriter.create(schema, file);
        AvroTextOutputFormat avroTextOutputFormat = new AvroTextOutputFormat();
        avroTextOutputFormat.getClass();
        AvroTextOutputFormat.AvroTextRecordWriter rw = new AvroTextOutputFormat.AvroTextRecordWriter(avroTextOutputFormat, fileWriter, "\t".getBytes(UTF8));
        rw.write(null, null);
        rw.write(null, (Object)NullWritable.get());
        rw.write((Object)NullWritable.get(), null);
        rw.write((Object)NullWritable.get(), (Object)NullWritable.get());
        rw.write((Object)"k1", null);
        rw.write((Object)"k2", (Object)NullWritable.get());
        rw.write(null, (Object)"v1");
        rw.write((Object)NullWritable.get(), (Object)"v2");
        rw.write((Object)"k3", (Object)"v3");
        rw.write((Object)new Text("k4"), (Object)new Text("v4"));
        rw.close(null);
        GenericDatumReader reader = new GenericDatumReader();
        DataFileReader fileReader = new DataFileReader(file, (DatumReader)reader);
        Assert.assertEquals((Object)"k1", (Object)this.asString((ByteBuffer)fileReader.next()));
        Assert.assertEquals((Object)"k2", (Object)this.asString((ByteBuffer)fileReader.next()));
        Assert.assertEquals((Object)"v1", (Object)this.asString((ByteBuffer)fileReader.next()));
        Assert.assertEquals((Object)"v2", (Object)this.asString((ByteBuffer)fileReader.next()));
        Assert.assertEquals((Object)"k3\tv3", (Object)this.asString((ByteBuffer)fileReader.next()));
        Assert.assertEquals((Object)"k4\tv4", (Object)this.asString((ByteBuffer)fileReader.next()));
        Assert.assertFalse((String)"End", (boolean)fileReader.hasNext());
    }

    private String asString(ByteBuffer buf) throws UnsupportedEncodingException {
        byte[] b = new byte[buf.remaining()];
        buf.get(b);
        return new String(b, UTF8);
    }
}

