/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import org.apache.avro.mapred.AvroAsTextInputFormat;
import org.apache.avro.mapred.AvroTextOutputFormat;
import org.apache.avro.mapred.WordCountUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Test;

public class TestAvroTextSort {
    @Test
    public void testSort() throws Exception {
        JobConf job = new JobConf();
        String dir = System.getProperty("test.dir", ".") + "/mapred";
        Path outputPath = new Path(dir + "/out");
        outputPath.getFileSystem((Configuration)job).delete(outputPath);
        WordCountUtil.writeLinesBytesFile();
        job.setInputFormat(AvroAsTextInputFormat.class);
        job.setOutputFormat(AvroTextOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(dir + "/in")});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
        JobClient.runJob((JobConf)job);
        WordCountUtil.validateSortedFile();
    }
}

