/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.Pair;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;

public class WordCountUtil {
    private static final File DIR = new File(System.getProperty("test.dir", ".") + "/mapred");
    public static final File LINES_FILE = new File(new File(DIR, "in"), "lines.avro");
    private static final File LINES_TEXT_FILE = new File(new File(DIR, "in"), "lines.txt");
    public static final File COUNTS_FILE = new File(new File(DIR, "out"), "part-00000.avro");
    private static final File SORTED_FILE = new File(new File(DIR, "out"), "part-00000.avro");
    public static final String[] LINES = new String[]{"the quick brown fox jumps over the lazy dog", "the cow jumps over the moon", "the rain in spain falls mainly on the plains"};
    public static final Map<String, Long> COUNTS = new TreeMap<String, Long>();
    private static final String STRING_KEY = "string-key";
    private static final String LONG_KEY = "long-key";
    private static final String BYTES_KEY = "bytes-key";
    private static final String STRING_META_VALUE = "value";
    private static final long LONG_META_VALUE = 666L;
    private static final byte[] BYTES_META_VALUE;

    public static void writeLinesFile() throws IOException {
        FileUtil.fullyDelete((File)DIR);
        GenericDatumWriter writer = new GenericDatumWriter();
        DataFileWriter out = new DataFileWriter((DatumWriter)writer);
        LINES_FILE.getParentFile().mkdirs();
        out.create(Schema.create((Schema.Type)Schema.Type.STRING), LINES_FILE);
        for (String line : LINES) {
            out.append((Object)new Utf8(line));
        }
        out.close();
    }

    public static void writeLinesBytesFile() throws IOException {
        FileUtil.fullyDelete((File)DIR);
        GenericDatumWriter writer = new GenericDatumWriter();
        DataFileWriter out = new DataFileWriter((DatumWriter)writer);
        LINES_FILE.getParentFile().mkdirs();
        out.create(Schema.create((Schema.Type)Schema.Type.BYTES), LINES_FILE);
        for (String line : LINES) {
            out.append((Object)ByteBuffer.wrap(line.getBytes("UTF-8")));
        }
        out.close();
    }

    public static void writeLinesTextFile() throws IOException {
        FileUtil.fullyDelete((File)DIR);
        LINES_FILE.getParentFile().mkdirs();
        PrintStream out = new PrintStream(LINES_TEXT_FILE);
        for (String line : LINES) {
            out.println(line);
        }
        out.close();
    }

    public static void validateCountsFile() throws Exception {
        SpecificDatumReader reader = new SpecificDatumReader();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(COUNTS_FILE));
        DataFileStream counts = new DataFileStream((InputStream)in, (DatumReader)reader);
        int numWords = 0;
        for (Pair wc : counts) {
            Assert.assertEquals((String)((Utf8)wc.key()).toString(), (Object)COUNTS.get(((Utf8)wc.key()).toString()), (Object)wc.value());
            ++numWords;
        }
        WordCountUtil.checkMeta(counts);
        ((InputStream)in).close();
        Assert.assertEquals((long)COUNTS.size(), (long)numWords);
    }

    public static void validateSortedFile() throws Exception {
        GenericDatumReader reader = new GenericDatumReader();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(SORTED_FILE));
        DataFileStream lines = new DataFileStream((InputStream)in, (DatumReader)reader);
        ArrayList<String> sortedLines = new ArrayList<String>();
        for (String line : LINES) {
            sortedLines.add(line);
        }
        Collections.sort(sortedLines);
        for (String expectedLine : sortedLines) {
            ByteBuffer buf = (ByteBuffer)lines.next();
            byte[] b = new byte[buf.remaining()];
            buf.get(b);
            Assert.assertEquals((Object)expectedLine, (Object)new String(b, "UTF-8").trim());
        }
        Assert.assertFalse((boolean)lines.hasNext());
    }

    public static void setMeta(JobConf job) {
        AvroJob.setOutputMeta((JobConf)job, (String)STRING_KEY, (String)STRING_META_VALUE);
        AvroJob.setOutputMeta((JobConf)job, (String)LONG_KEY, (long)666L);
        AvroJob.setOutputMeta((JobConf)job, (String)BYTES_KEY, (byte[])BYTES_META_VALUE);
    }

    public static void checkMeta(DataFileStream<?> in) throws Exception {
        Assert.assertEquals((Object)STRING_META_VALUE, (Object)in.getMetaString(STRING_KEY));
        Assert.assertEquals((long)666L, (long)in.getMetaLong(LONG_KEY));
        Assert.assertTrue((boolean)Arrays.equals(BYTES_META_VALUE, in.getMeta(BYTES_KEY)));
    }

    static {
        for (String line : LINES) {
            StringTokenizer tokens = new StringTokenizer(line);
            while (tokens.hasMoreTokens()) {
                String word = tokens.nextToken();
                long count = COUNTS.containsKey(word) ? COUNTS.get(word) : 0L;
                COUNTS.put(word, ++count);
            }
        }
        BYTES_META_VALUE = new byte[]{0, -128, -1};
    }
}

