/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.Pair;
import org.apache.avro.mapred.WordCountUtil;
import org.apache.avro.mapred.tether.TetherJob;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Test;

public class TestWordCountTether {
    private void _runjob(String proto) throws Exception {
        System.out.println(System.getProperty("java.class.path"));
        JobConf job = new JobConf();
        String dir = System.getProperty("test.dir", ".") + "/mapred";
        Path outputPath = new Path(dir + "/out");
        outputPath.getFileSystem((Configuration)job).delete(outputPath);
        WordCountUtil.writeLinesFile();
        File exec = new File(System.getProperty("java.home") + "/bin/java");
        String in = dir + "/in";
        ArrayList<String> execargs = new ArrayList<String>();
        execargs.add("-classpath");
        execargs.add(System.getProperty("java.class.path"));
        execargs.add("org.apache.avro.mapred.tether.WordCountTask");
        FileInputFormat.addInputPaths((JobConf)job, (String)in);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputPath);
        TetherJob.setExecutable((JobConf)job, (File)exec, execargs, (boolean)false);
        Schema outscheme = new Pair((CharSequence)new Utf8(""), Long.valueOf(0L)).getSchema();
        AvroJob.setInputSchema((JobConf)job, (Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        job.set("avro.output.schema", outscheme.toString());
        TetherJob.setProtocol((JobConf)job, (String)proto);
        TetherJob.runJob((JobConf)job);
        SpecificDatumReader reader = new SpecificDatumReader();
        BufferedInputStream cin = new BufferedInputStream(new FileInputStream(WordCountUtil.COUNTS_FILE));
        DataFileStream counts = new DataFileStream((InputStream)cin, (DatumReader)reader);
        int numWords = 0;
        for (Pair wc : counts) {
            Assert.assertEquals((String)((Utf8)wc.key()).toString(), (Object)WordCountUtil.COUNTS.get(((Utf8)wc.key()).toString()), (Object)wc.value());
            ++numWords;
        }
        ((InputStream)cin).close();
        Assert.assertEquals((long)WordCountUtil.COUNTS.size(), (long)numWords);
    }

    @Test
    public void testJob() throws Exception {
        this._runjob("sasl");
    }

    @Test
    public void testhtp() throws Exception {
        this._runjob("http");
    }
}

