/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.generic.GenericData;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestAvroKeyOutputFormat {
    private static final String SYNC_INTERVAL_KEY = "avro.mapred.sync.interval";
    private static final int TEST_SYNC_INTERVAL = 12345;
    @Rule
    public TemporaryFolder mTempDir = new TemporaryFolder();

    @Test
    public void testWithNullCodec() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt(SYNC_INTERVAL_KEY, 12345);
        this.testGetRecordWriter(conf, CodecFactory.nullCodec(), 12345);
    }

    @Test
    public void testWithDeflateCodec() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.setInt("avro.mapred.deflate.level", 3);
        this.testGetRecordWriter(conf, CodecFactory.deflateCodec((int)3), 64000);
    }

    @Test
    public void testWithSnappyCode() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.set("avro.output.codec", "snappy");
        conf.setInt(SYNC_INTERVAL_KEY, 12345);
        this.testGetRecordWriter(conf, CodecFactory.snappyCodec(), 12345);
    }

    @Test
    public void testWithBZip2Code() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.set("avro.output.codec", "bzip2");
        this.testGetRecordWriter(conf, CodecFactory.bzip2Codec(), 64000);
    }

    @Test
    public void testWithDeflateCodeWithHadoopConfig() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.DeflateCodec");
        conf.setInt("avro.mapred.deflate.level", -1);
        conf.setInt(SYNC_INTERVAL_KEY, 12345);
        this.testGetRecordWriter(conf, CodecFactory.deflateCodec((int)-1), 12345);
    }

    @Test
    public void testWithSnappyCodeWithHadoopConfig() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.SnappyCodec");
        this.testGetRecordWriter(conf, CodecFactory.snappyCodec(), 64000);
    }

    @Test
    public void testWithBZip2CodeWithHadoopConfig() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("mapred.output.compress", true);
        conf.set("mapred.output.compression.codec", "org.apache.hadoop.io.compress.BZip2Codec");
        conf.setInt(SYNC_INTERVAL_KEY, 12345);
        this.testGetRecordWriter(conf, CodecFactory.bzip2Codec(), 12345);
    }

    private void testGetRecordWriter(Configuration conf, CodecFactory expectedCodec, int expectedSyncInterval) throws IOException {
        Job job = new Job(conf);
        job.getConfiguration().set("mapred.output.dir", this.mTempDir.getRoot().getPath());
        Schema writerSchema = Schema.create((Schema.Type)Schema.Type.INT);
        AvroJob.setOutputKeySchema((Job)job, (Schema)writerSchema);
        TaskAttemptContext context = (TaskAttemptContext)EasyMock.createMock(TaskAttemptContext.class);
        EasyMock.expect((Object)context.getConfiguration()).andReturn((Object)job.getConfiguration()).anyTimes();
        EasyMock.expect((Object)context.getTaskAttemptID()).andReturn((Object)TaskAttemptID.forName((String)"attempt_200707121733_0001_m_000000_0")).anyTimes();
        EasyMock.expect((Object)context.getNumReduceTasks()).andReturn((Object)1);
        RecordWriter expectedRecordWriter = (RecordWriter)EasyMock.createMock(RecordWriter.class);
        AvroKeyOutputFormat.RecordWriterFactory recordWriterFactory = (AvroKeyOutputFormat.RecordWriterFactory)EasyMock.createMock(AvroKeyOutputFormat.RecordWriterFactory.class);
        Capture capturedCodecFactory = new Capture();
        EasyMock.expect((Object)recordWriterFactory.create((Schema)EasyMock.eq((Object)writerSchema), (GenericData)EasyMock.anyObject(GenericData.class), (CodecFactory)EasyMock.capture((Capture)capturedCodecFactory), (OutputStream)EasyMock.anyObject(OutputStream.class), EasyMock.eq((int)expectedSyncInterval))).andReturn((Object)expectedRecordWriter);
        EasyMock.replay((Object[])new Object[]{context});
        EasyMock.replay((Object[])new Object[]{expectedRecordWriter});
        EasyMock.replay((Object[])new Object[]{recordWriterFactory});
        AvroKeyOutputFormat outputFormat = new AvroKeyOutputFormat(recordWriterFactory);
        RecordWriter recordWriter = outputFormat.getRecordWriter(context);
        Assert.assertTrue((boolean)capturedCodecFactory.hasCaptured());
        Assert.assertEquals((Object)expectedCodec.toString(), (Object)((CodecFactory)capturedCodecFactory.getValue()).toString());
        EasyMock.verify((Object[])new Object[]{context});
        EasyMock.verify((Object[])new Object[]{expectedRecordWriter});
        EasyMock.verify((Object[])new Object[]{recordWriterFactory});
        Assert.assertNotNull((Object)recordWriter);
        Assert.assertTrue((expectedRecordWriter == recordWriter ? 1 : 0) != 0);
    }
}

