/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.SeekableFileInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroFiles;
import org.apache.avro.mapreduce.AvroKeyRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestAvroKeyRecordReader {
    @Rule
    public TemporaryFolder mTempDir = new TemporaryFolder();

    @Test
    public void testReadRecords() throws IOException, InterruptedException {
        SeekableFileInput avroFileInput = new SeekableFileInput(AvroFiles.createFile(new File(this.mTempDir.getRoot(), "myStringfile.avro"), Schema.create((Schema.Type)Schema.Type.STRING), "first", "second"));
        Schema readerSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        AvroKeyRecordReader<CharSequence> recordReader = new AvroKeyRecordReader<CharSequence>(readerSchema, (SeekableInput)avroFileInput){
            final /* synthetic */ SeekableInput val$avroFileInput;
            {
                this.val$avroFileInput = seekableInput;
                super(x0);
            }

            protected SeekableInput createSeekableInput(Configuration conf, Path path) throws IOException {
                return this.val$avroFileInput;
            }
        };
        Configuration conf = new Configuration();
        FileSplit inputSplit = (FileSplit)EasyMock.createMock(FileSplit.class);
        EasyMock.expect((Object)inputSplit.getPath()).andReturn((Object)new Path("/path/to/an/avro/file")).anyTimes();
        EasyMock.expect((Object)inputSplit.getStart()).andReturn((Object)0L).anyTimes();
        EasyMock.expect((Object)inputSplit.getLength()).andReturn((Object)avroFileInput.length()).anyTimes();
        TaskAttemptContext context = (TaskAttemptContext)EasyMock.createMock(TaskAttemptContext.class);
        EasyMock.expect((Object)context.getConfiguration()).andReturn((Object)conf).anyTimes();
        EasyMock.replay((Object[])new Object[]{inputSplit});
        EasyMock.replay((Object[])new Object[]{context});
        recordReader.initialize((InputSplit)inputSplit, context);
        Assert.assertEquals((String)"Progress should be zero before any records are read", (float)0.0f, (float)recordReader.getProgress(), (float)0.0f);
        Assert.assertTrue((String)"Expected at least one record", (boolean)recordReader.nextKeyValue());
        AvroKey key = (AvroKey)recordReader.getCurrentKey();
        NullWritable value = (NullWritable)recordReader.getCurrentValue();
        Assert.assertNotNull((String)"First record had null key", (Object)key);
        Assert.assertNotNull((String)"First record had null value", (Object)value);
        CharSequence firstString = (CharSequence)key.datum();
        Assert.assertEquals((Object)"first", (Object)firstString.toString());
        Assert.assertTrue((String)"getCurrentKey() returned different keys for the same record", (key == recordReader.getCurrentKey() ? 1 : 0) != 0);
        Assert.assertTrue((String)"getCurrentValue() returned different values for the same record", (value == recordReader.getCurrentValue() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected to read a second record", (boolean)recordReader.nextKeyValue());
        key = (AvroKey)recordReader.getCurrentKey();
        value = (NullWritable)recordReader.getCurrentValue();
        Assert.assertNotNull((String)"Second record had null key", (Object)key);
        Assert.assertNotNull((String)"Second record had null value", (Object)value);
        CharSequence secondString = (CharSequence)key.datum();
        Assert.assertEquals((Object)"second", (Object)secondString.toString());
        Assert.assertEquals((String)"Progress should be complete (2 out of 2 records processed)", (float)1.0f, (float)recordReader.getProgress(), (float)0.0f);
        Assert.assertFalse((String)"Expected only 2 records", (boolean)recordReader.nextKeyValue());
        recordReader.close();
        EasyMock.verify((Object[])new Object[]{inputSplit});
        EasyMock.verify((Object[])new Object[]{context});
    }
}

