/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.apache.avro.AvroTestUtil;
import org.apache.avro.mapred.FsInput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFsInput {
    private static File file;
    private static final String FILE_CONTENTS = "abcdefghijklmnopqrstuvwxyz";
    private Configuration conf;
    private FsInput fsInput;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        File directory = AvroTestUtil.tempDirectory(TestFsInput.class, (String)"file");
        file = new File(directory, "file.txt");
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));
        try {
            out.print(FILE_CONTENTS);
        }
        finally {
            out.close();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set("fs.default.name", "file:///");
        this.fsInput = new FsInput(new Path(file.getPath()), this.conf);
    }

    @After
    public void tearDown() throws Exception {
        if (this.fsInput != null) {
            this.fsInput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigurationConstructor() throws Exception {
        FsInput in = new FsInput(new Path(file.getPath()), this.conf);
        try {
            int expectedByteCount = 1;
            byte[] readBytes = new byte[expectedByteCount];
            int actualByteCount = this.fsInput.read(readBytes, 0, expectedByteCount);
            Assert.assertThat((Object)actualByteCount, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedByteCount)));
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileSystemConstructor() throws Exception {
        Path path = new Path(file.getPath());
        FileSystem fs = path.getFileSystem(this.conf);
        FsInput in = new FsInput(path, fs);
        try {
            int expectedByteCount = 1;
            byte[] readBytes = new byte[expectedByteCount];
            int actualByteCount = this.fsInput.read(readBytes, 0, expectedByteCount);
            Assert.assertThat((Object)actualByteCount, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedByteCount)));
        }
        finally {
            in.close();
        }
    }

    @Test
    public void testLength() throws IOException {
        Assert.assertEquals((long)this.fsInput.length(), (long)FILE_CONTENTS.length());
    }

    @Test
    public void testRead() throws Exception {
        byte[] expectedBytes = FILE_CONTENTS.getBytes(Charset.forName("UTF-8"));
        byte[] actualBytes = new byte[expectedBytes.length];
        int actualByteCount = this.fsInput.read(actualBytes, 0, actualBytes.length);
        Assert.assertThat((Object)actualBytes, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedBytes)));
        Assert.assertThat((Object)actualByteCount, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedBytes.length)));
    }

    @Test
    public void testSeek() throws Exception {
        int seekPos = FILE_CONTENTS.length() / 2;
        byte[] fileContentBytes = FILE_CONTENTS.getBytes(Charset.forName("UTF-8"));
        byte expectedByte = fileContentBytes[seekPos];
        this.fsInput.seek((long)seekPos);
        byte[] readBytes = new byte[1];
        this.fsInput.read(readBytes, 0, 1);
        byte actualByte = readBytes[0];
        Assert.assertThat((Object)actualByte, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedByte)));
    }

    @Test
    public void testTell() throws Exception {
        long expectedTellPos = FILE_CONTENTS.length() / 2;
        this.fsInput.seek(expectedTellPos);
        long actualTellPos = this.fsInput.tell();
        Assert.assertThat((Object)actualTellPos, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedTellPos)));
    }
}

