/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Protocol;
import org.apache.avro.compiler.idl.Idl;
import org.apache.avro.compiler.idl.ParseException;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.mojo.AbstractAvroMojo;

public class IDLProtocolMojo
extends AbstractAvroMojo {
    private String[] includes = new String[]{"**/*.avdl"};
    private String[] testIncludes = new String[]{"**/*.avdl"};

    @Override
    protected void doCompile(String filename, File sourceDirectory, File outputDirectory) throws IOException {
        Idl parser = new Idl(new File(sourceDirectory, filename));
        try {
            Protocol p = parser.CompilationUnit();
            String json = p.toString(true);
            Protocol protocol = Protocol.parse((String)json);
            SpecificCompiler compiler = new SpecificCompiler(protocol);
            compiler.compileToDestination(null, outputDirectory);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected String[] getIncludes() {
        return this.includes;
    }

    @Override
    protected String[] getTestIncludes() {
        return this.testIncludes;
    }
}

