/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public abstract class AbstractAvroMojo
extends AbstractMojo {
    private File sourceDirectory;
    private File outputDirectory;
    private File testSourceDirectory;
    private File testOutputDirectory;
    private String fieldVisibility;
    protected String[] imports;
    protected String[] excludes = new String[0];
    protected String[] testExcludes = new String[0];
    protected String stringType = "CharSequence";
    protected String templateDirectory = "/org/apache/avro/compiler/specific/templates/java/classic/";
    protected boolean createSetters;
    protected MavenProject project;

    public void execute() throws MojoExecutionException {
        String[] includedFiles;
        boolean hasTestDir;
        boolean hasSourceDir = null != this.sourceDirectory && this.sourceDirectory.isDirectory();
        boolean hasImports = null != this.imports;
        boolean bl = hasTestDir = null != this.testSourceDirectory && this.testSourceDirectory.isDirectory();
        if (!hasSourceDir && !hasTestDir) {
            throw new MojoExecutionException("neither sourceDirectory: " + this.sourceDirectory + " or testSourceDirectory: " + this.testSourceDirectory + " are directories");
        }
        if (hasImports) {
            for (String importedFile : this.imports) {
                File file = new File(importedFile);
                if (file.isDirectory()) {
                    Object[] includedFiles2 = this.getIncludedFiles(file.getAbsolutePath(), this.excludes, this.getIncludes());
                    this.getLog().info((CharSequence)("Importing Directory: " + file.getAbsolutePath()));
                    this.getLog().debug((CharSequence)("Importing Directory Files: " + Arrays.toString(includedFiles2)));
                    this.compileFiles((String[])includedFiles2, file, this.outputDirectory);
                    continue;
                }
                if (!file.isFile()) continue;
                this.getLog().info((CharSequence)("Importing File: " + file.getAbsolutePath()));
                this.compileFiles(new String[]{file.getName()}, file.getParentFile(), this.outputDirectory);
            }
        }
        if (hasSourceDir) {
            includedFiles = this.getIncludedFiles(this.sourceDirectory.getAbsolutePath(), this.excludes, this.getIncludes());
            this.compileFiles(includedFiles, this.sourceDirectory, this.outputDirectory);
        }
        if (hasImports || hasSourceDir) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        if (hasTestDir) {
            includedFiles = this.getIncludedFiles(this.testSourceDirectory.getAbsolutePath(), this.testExcludes, this.getTestIncludes());
            this.compileFiles(includedFiles, this.testSourceDirectory, this.testOutputDirectory);
            this.project.addTestCompileSourceRoot(this.testOutputDirectory.getAbsolutePath());
        }
    }

    private String[] getIncludedFiles(String absPath, String[] excludes, String[] includes) {
        FileSetManager fileSetManager = new FileSetManager();
        FileSet fs = new FileSet();
        fs.setDirectory(absPath);
        fs.setFollowSymlinks(false);
        if (this.imports != null) {
            String importExclude = null;
            for (String importFile : this.imports) {
                File file = new File(importFile);
                if (file.isDirectory()) {
                    importExclude = file.getName() + "/**";
                } else if (file.isFile()) {
                    importExclude = "**/" + file.getName();
                }
                fs.addExclude(importExclude);
            }
        }
        for (String include : includes) {
            fs.addInclude(include);
        }
        for (String exclude : excludes) {
            fs.addExclude(exclude);
        }
        return fileSetManager.getIncludedFiles(fs);
    }

    private void compileFiles(String[] files, File sourceDir, File outDir) throws MojoExecutionException {
        for (String filename : files) {
            try {
                this.doCompile(filename, sourceDir, outDir);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error compiling protocol file " + filename + " to " + outDir, (Exception)e);
            }
        }
    }

    protected SpecificCompiler.FieldVisibility getFieldVisibility() {
        try {
            String upper = String.valueOf(this.fieldVisibility).trim().toUpperCase();
            return SpecificCompiler.FieldVisibility.valueOf((String)upper);
        }
        catch (IllegalArgumentException e) {
            return SpecificCompiler.FieldVisibility.PUBLIC_DEPRECATED;
        }
    }

    protected abstract void doCompile(String var1, File var2, File var3) throws IOException;

    protected abstract String[] getIncludes();

    protected abstract String[] getTestIncludes();
}

